/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class DocumentBuilderEvents {
    private final List<DocumentBuilderEvent> events;

    public DocumentBuilderEvents(List<DocumentBuilderEvent> events) {
        this.events = ImmutableList.copyOf((Collection)Objects.requireNonNull(events, "Must provide events"));
    }

    public List<DocumentBuilderEvent> getEvents() {
        return this.events;
    }

    public void applyTo(DocumentBuilder builder) {
        Objects.requireNonNull(builder, "Must provide a builder");
        for (DocumentBuilderEvent event : this.events) {
            event.invoke(builder);
        }
    }

    public String toString() {
        return MessageFormat.format("{0} [events={1}]", this.events);
    }
}

