/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.element.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.PictureType;

public class MImageImpl
implements MImage {
    private final URI uri;
    private int width;
    private int height;
    private boolean conserveRatio;
    private double ratio;
    private PictureType type;
    private URIConverter uriConverter;

    public MImageImpl(URIConverter uriConverter, URI uri) {
        this(uriConverter, uri, PictureType.toType(uri));
    }

    public MImageImpl(URIConverter uriConverter, URI uri, PictureType type) {
        this.uriConverter = uriConverter;
        this.uri = uri;
        this.type = type;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream input = this.getInputStream();){
                BufferedImage image = ImageIO.read(input);
                if (image != null) {
                    this.width = image.getWidth();
                    this.height = image.getHeight();
                    this.conserveRatio = true;
                    this.ratio = (double)this.width / (double)this.height;
                } else {
                    this.conserveRatio = false;
                    this.ratio = -1.0;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.ratio = -1.0;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        if (this.conserveRatio) {
            this.height = (int)(1.0 / this.ratio * (double)width);
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        if (this.conserveRatio) {
            this.width = (int)(this.ratio * (double)height);
        }
    }

    @Override
    public boolean conserveRatio() {
        return this.conserveRatio;
    }

    @Override
    public void setConserveRatio(boolean conserveRatio) {
        if (conserveRatio && this.ratio < 0.0) {
            throw new IllegalStateException("Can't conserve ratio: unknown ratio");
        }
        this.conserveRatio = conserveRatio;
    }

    protected double getRatio() {
        return this.ratio;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.uriConverter.createInputStream(this.uri);
    }

    @Override
    public PictureType getType() {
        return this.type;
    }

    public String toString() {
        return "Image " + this.uri.toString();
    }
}

