/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class MessageLine
extends CLabel {
    private static final RGB ERROR_BACKGROUND_RGB = new RGB(230, 226, 221);
    private Color fNormalMsgAreaBackground = this.getBackground();
    private Color fErrorMsgAreaBackground = null;

    public MessageLine(Composite parent) {
        this(parent, 16384);
    }

    public MessageLine(Composite parent, int style) {
        super(parent, style);
    }

    private Image findImage(IStatus status) {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        if (status.isOK()) {
            return null;
        }
        if (status.matches(4)) {
            return provider.get(PDEPluginImages.DESC_ERROR_ST_OBJ);
        }
        if (status.matches(2)) {
            return provider.get(PDEPluginImages.DESC_WARNING_ST_OBJ);
        }
        if (status.matches(1)) {
            return provider.get(PDEPluginImages.DESC_INFO_ST_OBJ);
        }
        return null;
    }

    public void setErrorStatus(IStatus status) {
        String message;
        if (status != null && (message = status.getMessage()) != null && message.length() > 0) {
            this.setText(message);
            this.setImage(this.findImage(status));
            if (this.fErrorMsgAreaBackground == null) {
                this.fErrorMsgAreaBackground = new Color((Device)this.getDisplay(), ERROR_BACKGROUND_RGB);
            }
            this.setBackground(this.fErrorMsgAreaBackground);
            return;
        }
        this.setText("");
        this.setImage(null);
        this.setBackground(this.fNormalMsgAreaBackground);
    }

    public void dispose() {
        this.fErrorMsgAreaBackground = null;
        super.dispose();
    }
}

