/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.List;
import org.eclipse.comma.monitoring.lib.CPathDescription;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CMessageInfo {
    private CObservedMessage message;
    private List<CPathDescription> pathDescriptions;
    private String connection;
    private boolean complete = false;

    public CMessageInfo(CObservedMessage message, List<CPathDescription> paths, String connection) {
        this.message = message;
        this.pathDescriptions = paths;
        this.connection = connection;
        this.checkCompleteness();
    }

    public List<CPathDescription> getPathDescriptions() {
        return this.pathDescriptions;
    }

    public CObservedMessage getMessage() {
        return this.message;
    }

    public String getConnection() {
        return this.connection;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isSameConnection(CMessageInfo mInfo) {
        return mInfo.getConnection().equals(this.connection);
    }

    public void resolvePostEventStates(List<CPathDescription> newPathDescriptions) {
        this.complete = true;
        for (CPathDescription pd : this.pathDescriptions) {
            if (pd.postStatesKnown()) continue;
            for (CPathDescription newPd : newPathDescriptions) {
                String currentPath = pd.getPathId();
                String newPath = newPd.getPathId();
                if (!newPath.startsWith(currentPath)) continue;
                pd.setPostEventStates(newPd.getActiveStates());
                break;
            }
            pd.setPostStatesKnown();
        }
    }

    private void checkCompleteness() {
        this.complete = this.pathDescriptions.stream().allMatch(pd -> pd.postStatesKnown());
    }
}

