/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.parameters.validation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.generator.plantuml.ExpressionsUmlGenerator;
import org.eclipse.comma.parameters.ParametersUtils;
import org.eclipse.comma.parameters.parameters.NotificationParams;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.ParametersPackage;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.ReplyParams;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.parameters.validation.AbstractParametersValidator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ParametersValidator
extends AbstractParametersValidator {
    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
        }
    }

    @Check
    public void checkDuplicateEvents(Parameters m) {
        ArrayList<String> events = new ArrayList<String>();
        EList<TriggerParams> _triggerParams = m.getTriggerParams();
        for (TriggerParams triggerParams : _triggerParams) {
            boolean _contains = events.contains(triggerParams.getEvent().getName());
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'Duplicate trigger \"");
                String _name = triggerParams.getEvent().getName();
                _builder.append(_name);
                _builder.append("\"");
                this.error(_builder.toString(), triggerParams, (EStructuralFeature)ParametersPackage.Literals.TRIGGER_PARAMS__EVENT);
            }
            events.add(triggerParams.getEvent().getName());
        }
        events.clear();
        EList<NotificationParams> _notificationParams = m.getNotificationParams();
        for (NotificationParams notificationParams : _notificationParams) {
            boolean _contains = events.contains(notificationParams.getEvent().getName());
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'Duplicate notification \"");
                String _name = notificationParams.getEvent().getName();
                _builder.append(_name);
                _builder.append("\"");
                this.error(_builder.toString(), notificationParams, (EStructuralFeature)ParametersPackage.Literals.NOTIFICATION_PARAMS__EVENT);
            }
            events.add(notificationParams.getEvent().getName());
        }
        events.clear();
        EList<ReplyParams> _replyParams = m.getReplyParams();
        for (ReplyParams replyParams : _replyParams) {
            boolean _contains = events.contains(replyParams.getEvent().getName());
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'Duplicate reply to command \"");
                String _name = replyParams.getEvent().getName();
                _builder.append(_name);
                _builder.append("\"");
                this.error(_builder.toString(), replyParams, (EStructuralFeature)ParametersPackage.Literals.REPLY_PARAMS__EVENT);
            }
            events.add(replyParams.getEvent().getName());
        }
    }

    @Check
    public void checkEvents(Parameters m) {
        if (m.getInterface() == null || m.getInterface().getName() == null) {
            return;
        }
        Interface itf = m.getInterface();
        Map<State, List<InterfaceEvent>> uncoveredTriggers = ParametersUtils.getUncoveredTriggers(itf, m);
        Set<State> _keySet = uncoveredTriggers.keySet();
        for (State s : _keySet) {
            List<InterfaceEvent> _get = uncoveredTriggers.get(s);
            for (InterfaceEvent event : _get) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Trigger \"");
                String _name = event.getName();
                _builder.append(_name);
                _builder.append("\" is missing parameters for state ");
                String _name_1 = s.getName();
                _builder.append(_name_1);
                this.error(_builder.toString(), (EObject)m, null);
            }
        }
        Map<State, List<Notification>> uncoveredNotifications = ParametersUtils.getUncoveredNotifications(itf, m);
        Set<State> _keySet_1 = uncoveredNotifications.keySet();
        for (State s_1 : _keySet_1) {
            List<Notification> _get_1 = uncoveredNotifications.get(s_1);
            for (Notification event_1 : _get_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Notification \"");
                String _name_2 = event_1.getName();
                _builder_1.append(_name_2);
                _builder_1.append("\" is missing parameters for state ");
                String _name_3 = s_1.getName();
                _builder_1.append(_name_3);
                this.error(_builder_1.toString(), (EObject)m, null);
            }
        }
        Map<State, List<Command>> uncoveredReplies = ParametersUtils.getUncoveredReplies(itf, m);
        Set<State> _keySet_2 = uncoveredReplies.keySet();
        for (State s_2 : _keySet_2) {
            List<Command> _get_2 = uncoveredReplies.get(s_2);
            for (Command event_2 : _get_2) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Reply to command \"");
                String _name_4 = event_2.getName();
                _builder_2.append(_name_4);
                _builder_2.append("\" is missing parameters for state ");
                String _name_5 = s_2.getName();
                _builder_2.append(_name_5);
                this.error(_builder_2.toString(), (EObject)m, null);
            }
        }
    }

    @Check
    public void checkStateDuplication(TriggerParams p) {
        HashSet<String> coveredStates = new HashSet<String>();
        EList<StateParams> _stateParams = p.getStateParams();
        for (StateParams s : _stateParams) {
            final String stateName = s.getState().toString();
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String c) {
                    return stateName.equalsIgnoreCase(c);
                }
            };
            boolean _exists = IterableExtensions.exists(coveredStates, (Functions.Function1)_function);
            if (_exists) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("State \"");
                _builder.append(stateName);
                _builder.append("\" already used");
                this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__STATE);
                continue;
            }
            coveredStates.add(stateName);
        }
    }

    @Check
    public void checkStateDuplication(NotificationParams p) {
        HashSet<String> coveredStates = new HashSet<String>();
        EList<StateParams> _stateParams = p.getStateParams();
        for (StateParams s : _stateParams) {
            final String stateName = s.getState().toString();
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String c) {
                    return stateName.equalsIgnoreCase(c);
                }
            };
            boolean _exists = IterableExtensions.exists(coveredStates, (Functions.Function1)_function);
            if (_exists) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("State \"");
                _builder.append(stateName);
                _builder.append("\" already used");
                this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__STATE);
                continue;
            }
            coveredStates.add(stateName);
        }
    }

    @Check
    public void checkStateDuplication(ReplyParams p) {
        HashSet<String> coveredStates = new HashSet<String>();
        EList<StateParams> _stateParams = p.getStateParams();
        for (StateParams s : _stateParams) {
            final String stateName = s.getState().toString();
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String c) {
                    return stateName.equalsIgnoreCase(c);
                }
            };
            boolean _exists = IterableExtensions.exists(coveredStates, (Functions.Function1)_function);
            if (_exists) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("State \"");
                _builder.append(stateName);
                _builder.append("\" already used");
                this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__STATE);
                continue;
            }
            coveredStates.add(stateName);
        }
    }

    public void checkForDuplicateValues(List<StateParams> sp) {
        ExpressionsUmlGenerator uml = new ExpressionsUmlGenerator(null, null);
        for (StateParams s : sp) {
            HashSet<String> seenValues = new HashSet<String>();
            EList<Params> _params = s.getParams();
            for (Params p : _params) {
                boolean _not;
                String usedValueCombination = "";
                EList<Expression> _value = p.getValue();
                for (Expression e : _value) {
                    String expStr = uml.generateExpression(e).toString();
                    String _usedValueCombination = usedValueCombination;
                    usedValueCombination = String.valueOf(_usedValueCombination) + " " + expStr;
                }
                boolean _add = seenValues.add(usedValueCombination);
                boolean bl = _not = !_add;
                if (!_not) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Duplicate use of value combination\"");
                _builder.append(usedValueCombination);
                _builder.append("\"");
                this.error(_builder.toString(), p, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE);
            }
        }
    }

    @Check
    public void checkValuesDuplication(Parameters m) {
        EList<TriggerParams> _triggerParams = m.getTriggerParams();
        for (TriggerParams s : _triggerParams) {
            this.checkForDuplicateValues((List<StateParams>)s.getStateParams());
        }
        EList<NotificationParams> _notificationParams = m.getNotificationParams();
        for (NotificationParams s_1 : _notificationParams) {
            this.checkForDuplicateValues((List<StateParams>)s_1.getStateParams());
        }
        EList<ReplyParams> _replyParams = m.getReplyParams();
        for (ReplyParams s_2 : _replyParams) {
            this.checkForDuplicateValues((List<StateParams>)s_2.getStateParams());
        }
    }

    public void checkForAtLastOneNonSkip(List<StateParams> sp) {
        for (StateParams s : sp) {
            boolean seenNonSkip = false;
            boolean hasParam = false;
            EList<Params> _params = s.getParams();
            for (Params p : _params) {
                seenNonSkip = seenNonSkip || StringExtensions.isNullOrEmpty((String)p.getSkip());
                hasParam = true;
            }
            if (seenNonSkip || !hasParam) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("At least one paramater should not be skipped");
            this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
        }
    }

    @Check
    public void checkValuesAtLastOneNonSkip(Parameters m) {
        EList<TriggerParams> _triggerParams = m.getTriggerParams();
        for (TriggerParams s : _triggerParams) {
            this.checkForAtLastOneNonSkip((List<StateParams>)s.getStateParams());
        }
        EList<NotificationParams> _notificationParams = m.getNotificationParams();
        for (NotificationParams s_1 : _notificationParams) {
            this.checkForAtLastOneNonSkip((List<StateParams>)s_1.getStateParams());
        }
        EList<ReplyParams> _replyParams = m.getReplyParams();
        for (ReplyParams s_2 : _replyParams) {
            this.checkForAtLastOneNonSkip((List<StateParams>)s_2.getStateParams());
        }
    }

    @Check
    public void checkTriggerParams(TriggerParams triggerParams) {
        InterfaceEvent event = triggerParams.getEvent();
        EList<StateParams> _stateParams = triggerParams.getStateParams();
        for (StateParams paramsSet : _stateParams) {
            EList<Params> _params = paramsSet.getParams();
            for (Params params : _params) {
                int _size_1;
                boolean _notEquals;
                Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter it) {
                        DIRECTION _direction = it.getDirection();
                        return _direction != DIRECTION.OUT;
                    }
                };
                Iterable neededParams = IterableExtensions.filter((Iterable)event.getParameters(), (Functions.Function1)_function);
                int _size = params.getValue().size();
                boolean bl = _notEquals = _size != (_size_1 = IterableExtensions.size((Iterable)neededParams));
                if (_notEquals) {
                    this.error("Wrong number of parameters", paramsSet, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
                    continue;
                }
                EList<Expression> _value = params.getValue();
                for (Expression e : _value) {
                    boolean _not;
                    boolean _subTypeOf = this.subTypeOf(this.typeOf(e), TypeUtilities.getTypeObject((Type)((Parameter[])Conversions.unwrapArray((Object)neededParams, Parameter.class))[params.getValue().indexOf((Object)e)].getType()));
                    boolean bl2 = _not = !_subTypeOf;
                    if (!_not) continue;
                    this.error("Type mismatch for parameter", params, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE, params.getValue().indexOf((Object)e));
                }
            }
        }
    }

    @Check
    public void checkNotificationParams(NotificationParams notificationParams) {
        Notification event = notificationParams.getEvent();
        EList<StateParams> _stateParams = notificationParams.getStateParams();
        for (StateParams paramsSet : _stateParams) {
            EList<Params> _params = paramsSet.getParams();
            for (Params params : _params) {
                int _size_1;
                boolean _notEquals;
                int _size = params.getValue().size();
                boolean bl = _notEquals = _size != (_size_1 = event.getParameters().size());
                if (_notEquals) {
                    this.error("Wrong number of parameters", paramsSet, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
                    continue;
                }
                EList<Expression> _value = params.getValue();
                for (Expression e : _value) {
                    boolean _not;
                    boolean _subTypeOf = this.subTypeOf(this.typeOf(e), TypeUtilities.getTypeObject((Type)((Parameter)event.getParameters().get(params.getValue().indexOf((Object)e))).getType()));
                    boolean bl2 = _not = !_subTypeOf;
                    if (!_not) continue;
                    this.error("Type mismatch for parameter", params, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE, params.getValue().indexOf((Object)e));
                }
            }
        }
    }

    @Check
    public void checkReplyParams(ReplyParams replyParams) {
        boolean _not;
        Command command = replyParams.getEvent();
        ArrayList<Type> expectedTypes = new ArrayList<Type>();
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                DIRECTION _direction = it.getDirection();
                return _direction != DIRECTION.IN;
            }
        };
        Functions.Function1<Parameter, Type> _function_1 = new Functions.Function1<Parameter, Type>(){

            public Type apply(Parameter it) {
                return it.getType();
            }
        };
        Iterables.addAll(expectedTypes, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)command.getParameters(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _isVoid = TypeUtilities.isVoid((Type)command.getType());
        boolean bl = _not = !_isVoid;
        if (_not) {
            expectedTypes.add(command.getType());
        }
        EList<StateParams> _stateParams = replyParams.getStateParams();
        for (StateParams paramsSet : _stateParams) {
            EList<Params> _params = paramsSet.getParams();
            for (Params params : _params) {
                int _size_1;
                boolean _notEquals;
                int _size = params.getValue().size();
                boolean bl2 = _notEquals = _size != (_size_1 = expectedTypes.size());
                if (_notEquals) {
                    this.error("Wrong number of parameters", paramsSet, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
                    continue;
                }
                EList<Expression> _value = params.getValue();
                for (Expression e : _value) {
                    boolean _not_1;
                    boolean _subTypeOf = this.subTypeOf(this.typeOf(e), TypeUtilities.getTypeObject((Type)((Type)expectedTypes.get(params.getValue().indexOf((Object)e)))));
                    boolean bl3 = _not_1 = !_subTypeOf;
                    if (!_not_1) continue;
                    this.error("Type mismatch for parameter", params, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE, params.getValue().indexOf((Object)e));
                }
            }
        }
    }
}

