/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emfplus;

import java.io.IOException;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecord;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecordType;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;

@Internal
public class HemfPlusHeader
implements HemfPlusRecord {
    private int flags;
    private long version;
    private long emfPlusFlags;
    private long logicalDpiX;
    private long logicalDpiY;

    @Override
    public HemfPlusRecordType getEmfPlusRecordType() {
        return HemfPlusRecordType.header;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
        this.flags = flags;
        this.version = leis.readUInt();
        assert ((this.version & 0xFFFFFFFFFFFFFA00L) == 3686797312L && ((this.version & 0x3FFL) == 1L || (this.version & 0x3FFL) == 2L));
        this.emfPlusFlags = leis.readUInt();
        this.logicalDpiX = leis.readUInt();
        this.logicalDpiY = leis.readUInt();
        return 16L;
    }

    public long getVersion() {
        return this.version;
    }

    public long getEmfPlusFlags() {
        return this.emfPlusFlags;
    }

    public long getLogicalDpiX() {
        return this.logicalDpiX;
    }

    public long getLogicalDpiY() {
        return this.logicalDpiY;
    }

    public String toString() {
        return "HemfPlusHeader{flags=" + this.flags + ", version=" + this.version + ", emfPlusFlags=" + this.emfPlusFlags + ", logicalDpiX=" + this.logicalDpiX + ", logicalDpiY=" + this.logicalDpiY + '}';
    }
}

