/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.generator;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.sourceforge.plantuml.SourceFileReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.comma.java.JArtifactInfo;
import org.eclipse.comma.java.JArtifactInfoBuilder;
import org.eclipse.comma.java.JCmd;
import org.eclipse.comma.java.JCmdBuilder;
import org.eclipse.comma.java.JCmdExecutor;
import org.eclipse.comma.java.JCompiler;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.JDependencyInfos;
import org.eclipse.comma.java.JProcessMonitor;
import org.eclipse.comma.java.JSourceInfos;
import org.eclipse.comma.monitoring.dashboard.DashboardHelper;
import org.eclipse.comma.monitoring.lib.CTask;
import org.eclipse.comma.types.generator.CmdLineContext;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CommaMain {
    private static final String ERR_LOCATION_MISSING = "Location is not provided as argument";
    private static final String ERR_LOCATION_WRONG = "Location could not be found. ";
    private static final String INFO_GENERATION_FINISHED = "Code generation finished.";
    private static final String INFO_COMMA_FINISHED = "All CommaSuite Tasks are finished.";
    private static final String INFO_SEARCHING = "Searching for {0} ({1}) files in {2}";
    private static final String INFO_OUTPUT = "Output set: ";
    private static final String INFO_STOP = "Errors found, stopping generation.";
    private static final String INFO_READING = "-> Reading ";
    private static final String INFO_EMPTY_LOCATION = "Location contained no project files. ";
    private static final String OPT_HELP = "help";
    private static final String OPT_HELP_C = "h";
    private static final String OPT_HELP_DESCRIPTION = "Show options.";
    private static final String OPT_LOCATION = "location";
    private static final String OPT_LOCATION_C = "l";
    private static final String OPT_LOCATION_DESCRIPTION = "Location of the file or directory (Required argument)";
    private static final String OPT_VALIDATION = "validation";
    private static final String OPT_VALIDATION_C = "v";
    private static final String OPT_VALIDATION_DESCRIPTION = "Turns OFF validation, validation is ON by default.";
    private static final String OPT_OUTPUT = "output";
    private static final String OPT_OUTPUT_C = "o";
    private static final String OPT_OUTPUT_DESCRIPTION = "Set output location of the generated files, the default is \"src-gen\" at the provided \"location\".";
    private static final String DEFAULT_OUTPUT_DIR = "src-gen";
    private static final String OPT_CLEAN_C = "c";
    private static final String OPT_CLEAN_DESCRIPTION = "Turns ON cleaning the output folder before generation, clean is OFF by default.";
    private static final String OPT_CLEAN = "clean";
    private static final String OPT_MODELPATH_C = "mp";
    private static final String OPT_MODELPATH_DESCRIPTION = "List of semicolon separated directories that contain the input models.";
    private static final String OPT_MODELPATH = "modelpath";
    private static final String OPT_SKIPTASKS_C = "s";
    private static final String OPT_SKIPTASKS_DESCRIPTION = "List of semicolon separated project task names that will not be executed.";
    private static final String OPT_SKIPTASKS = "skip";
    private static final String OPT_RUNTASKS_C = "r";
    private static final String OPT_RUNTASKS_DESCRIPTION = "List of semicolon separated project task names that will be executed.";
    private static final String OPT_RUNTASKS = "run";
    private static final String MONITOR_MAIN_CLASS = "org.eclipse.comma.monitoring.generated.ScenarioPlayer";
    private static final String MONITOR_MAIN_CLASS_PATH = "java/org/eclipse/comma/monitoring/generated/ScenarioPlayer.java";
    private static final String GENERATED_JAR_NAME = "Player.jar";
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    private String[] args;
    private String description;
    private String language;
    private String ext;
    private Options options;

    public Options configure(String[] args, String description, String language, String ext) {
        Options _xblockexpression = null;
        this.args = args;
        this.description = description;
        this.language = language;
        this.ext = ext;
        _xblockexpression = this.options = this.createOptions();
        return _xblockexpression;
    }

    public void read() {
        try {
            boolean _isEmpty = ((List)Conversions.doWrapArray((Object)this.args)).isEmpty();
            if (_isEmpty) {
                System.err.println(ERR_LOCATION_MISSING);
                this.showInfo(this.description, this.options);
                System.exit(1);
                return;
            }
            DefaultParser parser = new DefaultParser();
            CommandLine cmdLine = parser.parse(this.options, this.args);
            boolean _hasOption = cmdLine.hasOption(OPT_HELP);
            if (_hasOption) {
                this.showInfo(this.description, this.options);
            } else {
                boolean _not;
                if (cmdLine.hasOption(OPT_RUNTASKS) && cmdLine.hasOption(OPT_SKIPTASKS)) {
                    System.err.println("Skip and Run tasks options cannot be used at the same time.");
                    System.exit(1);
                    return;
                }
                Path locationPath = this.getLocation(cmdLine);
                if (locationPath == null) {
                    System.err.println(ERR_LOCATION_MISSING);
                    this.showInfo(this.description, this.options);
                    System.exit(1);
                    return;
                }
                boolean _exists = Files.exists(locationPath, LinkOption.NOFOLLOW_LINKS);
                boolean bl = _not = !_exists;
                if (_not) {
                    String _string = locationPath.toString();
                    String _plus = ERR_LOCATION_WRONG + _string;
                    System.out.println(_plus);
                    System.exit(1);
                    return;
                }
                boolean _hasOption_1 = cmdLine.hasOption(OPT_VALIDATION);
                boolean validation = !_hasOption_1;
                boolean _isDirectory = Files.isDirectory(locationPath, LinkOption.NOFOLLOW_LINKS);
                if (_isDirectory) {
                    InputOutput.println((Object)MessageFormat.format(INFO_SEARCHING, this.language, this.ext, locationPath.toString()));
                    String _string_1 = locationPath.toString();
                    File dir = new File(_string_1);
                    File[] prjFiles = dir.listFiles(this.createFileFilter(this.ext));
                    int _size = ((List)Conversions.doWrapArray((Object)prjFiles)).size();
                    boolean createOutputSubFolders = _size > 1;
                    File[] fileArray = prjFiles;
                    int n = prjFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        String _xifexpression = null;
                        _xifexpression = createOutputSubFolders ? file.getName().substring(0, file.getName().lastIndexOf(".")) : "";
                        Path outputdir = this.getOutputdir(cmdLine, locationPath, _xifexpression);
                        System.out.println(INFO_OUTPUT + outputdir);
                        this.cleanOutput(cmdLine, outputdir);
                        this.runGeneration(file.getAbsolutePath(), outputdir.toString(), validation, cmdLine);
                        System.out.println(INFO_GENERATION_FINISHED);
                        this.runMonitoring(outputdir);
                        ++n2;
                    }
                    boolean _isEmpty_1 = ((List)Conversions.doWrapArray((Object)prjFiles)).isEmpty();
                    if (_isEmpty_1) {
                        String _string_2 = locationPath.toString();
                        String _plus_1 = INFO_EMPTY_LOCATION + _string_2;
                        System.out.println(_plus_1);
                    }
                } else {
                    Path outputdir = this.getOutputdir(cmdLine, locationPath, "");
                    System.out.println(INFO_OUTPUT + outputdir);
                    this.cleanOutput(cmdLine, outputdir);
                    this.runGeneration(locationPath.toString(), outputdir.toString(), validation, cmdLine);
                    System.out.println(INFO_GENERATION_FINISHED);
                    this.runMonitoring(outputdir);
                }
                System.out.println("");
                System.out.println(INFO_COMMA_FINISHED);
                System.exit(0);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Options createOptions() {
        Options _xblockexpression = null;
        Options options = new Options();
        options.addOption(OPT_LOCATION_C, OPT_LOCATION, true, OPT_LOCATION_DESCRIPTION);
        options.addOption(OPT_OUTPUT_C, OPT_OUTPUT, true, OPT_OUTPUT_DESCRIPTION);
        options.addOption(OPT_HELP_C, OPT_HELP, false, OPT_HELP_DESCRIPTION);
        options.addOption(OPT_VALIDATION_C, OPT_VALIDATION, false, OPT_VALIDATION_DESCRIPTION);
        options.addOption(OPT_CLEAN_C, OPT_CLEAN, false, OPT_CLEAN_DESCRIPTION);
        options.addOption(OPT_MODELPATH_C, OPT_MODELPATH, true, OPT_MODELPATH_DESCRIPTION);
        options.addOption(OPT_SKIPTASKS_C, OPT_SKIPTASKS, true, OPT_SKIPTASKS_DESCRIPTION);
        _xblockexpression = options.addOption(OPT_RUNTASKS_C, OPT_RUNTASKS, true, OPT_RUNTASKS_DESCRIPTION);
        return _xblockexpression;
    }

    public void showInfo(String description, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(description, options);
    }

    public FilenameFilter createFileFilter(final String ext) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(ext);
            }
        };
    }

    public Path getLocation(CommandLine cmdLine) {
        String location = cmdLine.getOptionValue(OPT_LOCATION);
        if (location != null) {
            Path locationPath = Paths.get(location, new String[0]);
            boolean _isAbsolute = locationPath.isAbsolute();
            if (_isAbsolute) {
                return locationPath;
            }
            Path current = Paths.get("", new String[0]).toAbsolutePath();
            return current.resolve(locationPath);
        }
        return null;
    }

    public Path getOutputdir(CommandLine cmdLine, Path location, String prjDir) {
        boolean _hasOption = cmdLine.hasOption(OPT_OUTPUT);
        if (_hasOption) {
            Path outputPath = Paths.get(cmdLine.getOptionValue(OPT_OUTPUT), new String[0]).resolve(prjDir).resolve(DEFAULT_OUTPUT_DIR);
            boolean _isAbsolute = outputPath.isAbsolute();
            if (_isAbsolute) {
                return outputPath;
            }
            boolean _isDirectory = Files.isDirectory(location, LinkOption.NOFOLLOW_LINKS);
            if (_isDirectory) {
                return location.resolve(outputPath).normalize();
            }
            Path dirLocation = Paths.get(location.toString().substring(0, location.toString().lastIndexOf(File.separator)), new String[0]);
            return dirLocation.resolve(outputPath);
        }
        boolean _isDirectory_1 = Files.isDirectory(location, LinkOption.NOFOLLOW_LINKS);
        if (_isDirectory_1) {
            return location.resolve(prjDir).resolve(DEFAULT_OUTPUT_DIR).normalize();
        }
        Path dirLocation_1 = Paths.get(location.toString().substring(0, location.toString().lastIndexOf(File.separator)), new String[0]);
        return dirLocation_1.resolve(prjDir).resolve(DEFAULT_OUTPUT_DIR);
    }

    public Set<String> getResourceExtensions() {
        HashSet<String> _xblockexpression = null;
        Set _keySet = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().keySet();
        HashSet<String> resourceExtensions = new HashSet<String>(_keySet);
        resourceExtensions.remove("events");
        resourceExtensions.remove("prj");
        resourceExtensions.remove("traces");
        _xblockexpression = resourceExtensions;
        return _xblockexpression;
    }

    public void loadResources(final ResourceSet set, String[] modelDirs) {
        try {
            final Set<String> resExtensions = this.getResourceExtensions();
            String[] stringArray = modelDirs;
            int n = modelDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String modelDirStr = stringArray[n2];
                File modelDir = new File(modelDirStr);
                boolean _isDirectory = modelDir.isDirectory();
                if (_isDirectory) {
                    Predicate<Path> _function = new Predicate<Path>(){

                        @Override
                        public boolean test(Path it) {
                            return it != null && it.toFile().isFile();
                        }
                    };
                    Stream<Path> files = Files.walk(Paths.get(modelDir.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(_function);
                    Consumer<Path> _function_1 = new Consumer<Path>(){

                        @Override
                        public void accept(Path it) {
                            int _lastIndexOf;
                            int _plus;
                            String fileAbsolutePath = it.toAbsolutePath().toString();
                            String fileExt = fileAbsolutePath.substring(_plus = (_lastIndexOf = fileAbsolutePath.lastIndexOf(".")) + 1);
                            boolean _contains = resExtensions.contains(fileExt);
                            if (_contains) {
                                System.out.println("Loading: " + fileAbsolutePath);
                                set.getResource(URI.createFileURI((String)fileAbsolutePath), true);
                            }
                        }
                    };
                    files.forEach(_function_1);
                } else {
                    System.out.println("Skipping " + modelDirStr + ". Not a directory.");
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void runGeneration(String string, String outputdir, Boolean validation, CommandLine cmdLine) {
        boolean _not;
        System.out.println(INFO_READING + string);
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        boolean _hasOption = cmdLine.hasOption(OPT_MODELPATH);
        if (_hasOption) {
            String[] modelDirs = cmdLine.getOptionValue(OPT_MODELPATH).split(";");
            this.loadResources(set, modelDirs);
        }
        Resource resource = set.getResource(URI.createFileURI((String)string), true);
        if (validation.booleanValue()) {
            boolean errorsFound = false;
            this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

                public Boolean apply(Resource it) {
                    boolean _endsWith = it.getURI().toString().endsWith("types.types");
                    return !_endsWith;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)set.getResources(), (Functions.Function1)_function);
            for (Resource res : _filter) {
                boolean _not2;
                Functions.Function1<Issue, Boolean> _function_1 = new Functions.Function1<Issue, Boolean>(){

                    public Boolean apply(Issue it) {
                        Severity _severity = it.getSeverity();
                        return Objects.equal((Object)_severity, (Object)Severity.ERROR);
                    }
                };
                Iterable issues = IterableExtensions.filter((Iterable)this.validator.validate(res, CheckMode.ALL, CancelIndicator.NullImpl), (Functions.Function1)_function_1);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)issues);
                boolean bl = _not2 = !_isEmpty;
                if (!_not2) continue;
                Consumer<Issue> _function_2 = new Consumer<Issue>(){

                    @Override
                    public void accept(Issue it) {
                        System.err.println(it);
                    }
                };
                issues.forEach(_function_2);
                errorsFound = true;
            }
            if (errorsFound) {
                System.out.println(INFO_STOP);
                System.exit(1);
                return;
            }
        }
        this.fileAccess.setOutputPath(outputdir);
        this.setCommaGen(this.fileAccess, outputdir);
        CmdLineContext context = new CmdLineContext();
        this.initializeContext(context, cmdLine);
        this.generator.generate(resource, (IFileSystemAccess2)this.fileAccess, (IGeneratorContext)context);
        boolean _isSuccess = context.isSuccess();
        boolean bl = _not = !_isSuccess;
        if (_not) {
            System.err.println(context.getErrorString());
            System.exit(1);
            return;
        }
    }

    public String cleanOutput(CommandLine cmdLine, Path outputdir) {
        try {
            String _xifexpression = null;
            boolean _hasOption = cmdLine.hasOption(OPT_CLEAN);
            if (_hasOption) {
                String _string_1;
                boolean _exists_1;
                String _xblockexpression = null;
                InputOutput.println((Object)"Start cleaning output directory.");
                Path commagendir = outputdir.getParent().resolve(CommaFileSystemAccess.COMMA_OUTPUT_CONF.getOutputDirectory()).normalize();
                String _string = outputdir.toString();
                boolean _exists = new File(_string).exists();
                if (_exists) {
                    Consumer<Path> _function = new Consumer<Path>(){

                        @Override
                        public void accept(Path it) {
                            try {
                                Files.delete(it);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    Files.walk(outputdir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(_function);
                }
                if (_exists_1 = new File(_string_1 = commagendir.toString()).exists()) {
                    Consumer<Path> _function_1 = new Consumer<Path>(){

                        @Override
                        public void accept(Path it) {
                            try {
                                Files.delete(it);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    Files.walk(commagendir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(_function_1);
                }
                _xifexpression = _xblockexpression = (String)InputOutput.println((Object)"Clean finished.");
            }
            return _xifexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public OutputConfiguration setCommaGen(JavaIoFileSystemAccess fileAccess, String outputdir) {
        boolean _not;
        OutputConfiguration _xblockexpression = null;
        OutputConfiguration commaConf = CommaFileSystemAccess.COMMA_OUTPUT_CONF;
        boolean _contains = commaConf.getOutputDirectory().contains(Paths.get(outputdir, new String[0]).getParent().toString());
        boolean bl = _not = !_contains;
        if (_not) {
            String _string = Paths.get(outputdir, new String[0]).getParent().toString();
            String _plus = String.valueOf(_string) + "./comma-gen";
            commaConf.setOutputDirectory(_plus);
        }
        _xblockexpression = fileAccess.getOutputConfigurations().put("outputCommaGen", commaConf);
        return _xblockexpression;
    }

    public String getCommaGen() {
        String _xblockexpression = null;
        OutputConfiguration commaGen = (OutputConfiguration)this.fileAccess.getOutputConfigurations().get("outputCommaGen");
        _xblockexpression = commaGen.getOutputDirectory();
        return _xblockexpression;
    }

    public void runMonitoring(Path outputPath) {
        try {
            boolean _not_1;
            boolean _not;
            String javaSourcePath = outputPath.resolve("java/").toString();
            Path scenarioPlayerPath = outputPath.resolve(MONITOR_MAIN_CLASS_PATH);
            boolean _exists = scenarioPlayerPath.toFile().exists();
            boolean bl = _not = !_exists;
            if (_not) {
                return;
            }
            Set generatedSourceInfos = JSourceInfos.getJavaSourcesFromSrcDirectory((String)javaSourcePath);
            java.net.URI _uRI = CTask.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            File monitorRuntimeJar = new File(_uRI);
            java.net.URI _uRI_1 = DashboardHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            File dashboardJar = new File(_uRI_1);
            java.net.URI _uRI_2 = Gson.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            File gsonJar = new File(_uRI_2);
            java.net.URI _uRI_3 = SourceFileReader.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            File plantumlJar = new File(_uRI_3);
            JDependencyInfo monitorRuntimeDependency = JDependencyInfos.create((File)monitorRuntimeJar);
            JDependencyInfo gsonDependency = JDependencyInfos.create((File)gsonJar);
            JDependencyInfo dashboardDependency = JDependencyInfos.create((File)dashboardJar);
            JDependencyInfo plantumlDependency = JDependencyInfos.create((File)plantumlJar);
            JCompiler compiler = new JCompiler().withSourceInfos((Collection)generatedSourceInfos).withDependencyInfos(new JDependencyInfo[]{monitorRuntimeDependency}).withDependencyInfos(new JDependencyInfo[]{gsonDependency}).withDependencyInfos(new JDependencyInfo[]{dashboardDependency}).withDependencyInfos(new JDependencyInfo[]{plantumlDependency});
            System.out.println("Compiling and building generated monitoring code ...");
            List classInfos = compiler.compile();
            JArtifactInfoBuilder _jArtifactInfoBuilder = new JArtifactInfoBuilder();
            File _file = new File(String.valueOf(javaSourcePath) + File.separator + GENERATED_JAR_NAME);
            JArtifactInfo artifactInfo = _jArtifactInfoBuilder.withArchiveFile(_file).withClassInfos((Collection)classInfos).withDependencyInfos(new JDependencyInfo[]{monitorRuntimeDependency}).withDependencyInfos(new JDependencyInfo[]{gsonDependency}).withDependencyInfos(new JDependencyInfo[]{dashboardDependency}).withDependencyInfos(new JDependencyInfo[]{plantumlDependency}).withMainClass(MONITOR_MAIN_CLASS).build();
            JCmd cmd = new JCmdBuilder().withArtifactInfo(artifactInfo).build();
            System.out.println("Executing monitoring tasks...");
            Consumer<String> _function = new Consumer<String>(){

                @Override
                public void accept(String text) {
                    System.out.print(text);
                }
            };
            JProcessMonitor monitor = new JCmdExecutor(cmd).withWorkingDirectory(outputPath.resolve("../").normalize().toFile()).withOnStdOut((Consumer)_function).execute();
            monitor.process.waitFor();
            boolean _isEmpty = monitor.getStdErr().isEmpty();
            boolean bl2 = _not_1 = !_isEmpty;
            if (_not_1) {
                System.out.println("Error occurred during compilation and execution:");
                System.out.print(monitor.getStdErr());
                System.exit(1);
            }
            double _executionTime = monitor.getExecutionTime();
            String _plus = "Finished executing monitoring tasks in " + Double.valueOf(_executionTime);
            String _plus_1 = String.valueOf(_plus) + " secs";
            System.out.println(_plus_1);
            this.convertPlantUml();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void convertPlantUml() {
        try {
            boolean _not;
            ArrayList<File> plantumlFiles = new ArrayList<File>();
            String _commaGen = this.getCommaGen();
            File _file = new File(_commaGen);
            this.findPlantUmlFiles(_file, plantumlFiles);
            boolean _isEmpty = plantumlFiles.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                InputOutput.println((Object)"Monitoring errors found, converting plantuml files to images.");
                for (File plantFile : plantumlFiles) {
                    boolean _not_1;
                    String _name = plantFile.getName();
                    String _plus = "--> " + _name;
                    InputOutput.println((Object)_plus);
                    SourceFileReader reader = new SourceFileReader(plantFile);
                    boolean _isEmpty_1 = reader.getGeneratedImages().isEmpty();
                    boolean bl2 = _not_1 = !_isEmpty_1;
                    if (!_not_1) continue;
                    reader.getGeneratedImages().get(0);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void findPlantUmlFiles(File dir, List<File> plantuml) {
        File[] _listFiles;
        File[] fileArray = _listFiles = dir.listFiles();
        int n = _listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _isDirectory;
            File file = fileArray[n2];
            boolean _endsWith = file.getName().endsWith(".plantuml");
            if (_endsWith) {
                plantuml.add(file);
            }
            if (_isDirectory = file.isDirectory()) {
                this.findPlantUmlFiles(file, plantuml);
            }
            ++n2;
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public Set<String> initializeContext(CmdLineContext context, CommandLine cmdLine) {
        Set<String> _xblockexpression = null;
        for (Option o : cmdLine) {
            context.addArgument(o.getOpt(), o.getValue());
        }
        Set<String> _xifexpression = null;
        boolean _hasOption = cmdLine.hasOption(OPT_RUNTASKS);
        if (_hasOption) {
            _xifexpression = context.setRequestedTasks(IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)cmdLine.getOptionValue(OPT_RUNTASKS).split(";")))));
        } else {
            Set<String> _xifexpression_1 = null;
            boolean _hasOption_1 = cmdLine.hasOption(OPT_SKIPTASKS);
            if (_hasOption_1) {
                _xifexpression_1 = context.setExcludedTasks(IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)cmdLine.getOptionValue(OPT_SKIPTASKS).split(";")))));
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

