/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks.dashboard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;

public class DashboardHelper {
    static byte[] placeholder = "\"%REPORT%\"".getBytes(StandardCharsets.UTF_8);
    static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    private static byte[] getHTML() {
        InputStream in = DashboardHelper.class.getClassLoader().getResourceAsStream("modelqualitychecks_dashboard.html");
        if (in != null) {
            try {
                return in.readAllBytes();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static String renderUmlBase64(String uml) throws IOException {
        SourceStringReader reader = new SourceStringReader(uml);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.PNG));
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    private static int placeholderStart(byte[] template) {
        int placeholderStart = 0;
        int placeholderIndex = 0;
        int i = 0;
        while (i < template.length) {
            if (template[i] == placeholder[placeholderIndex]) {
                if (placeholderIndex == 0) {
                    placeholderStart = i;
                } else if (placeholderIndex == placeholder.length - 1) break;
                ++placeholderIndex;
            } else {
                placeholderIndex = 0;
            }
            ++i;
        }
        return placeholderStart;
    }

    private static byte[] getReport(JsonObject report, Interface itf) throws IOException {
        report = (JsonObject)gson.fromJson(gson.toJson((JsonElement)report), JsonObject.class);
        report.remove("text");
        JsonObject meta = new JsonObject();
        meta.addProperty("createdAt", LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
        report.add("meta", (JsonElement)meta);
        InputStream itfIn = itf.eResource().getResourceSet().getURIConverter().createInputStream(itf.eResource().getURI());
        String itfText = new BufferedReader(new InputStreamReader(itfIn)).lines().collect(Collectors.joining("\n"));
        String itfBase64 = Base64.getEncoder().encodeToString(itfText.getBytes());
        JsonObject itfObj = new JsonObject();
        itfObj.addProperty("content", itfBase64);
        report.add("interface", (JsonElement)itfObj);
        for (String key : report.keySet()) {
            if (!(report.get(key) instanceof JsonArray)) continue;
            for (JsonElement item : report.getAsJsonArray(key)) {
                JsonObject obj;
                if (!(item instanceof JsonObject) || !(obj = (JsonObject)item).has("image")) continue;
                obj.addProperty("image", DashboardHelper.renderUmlBase64(obj.get("image").getAsString()));
            }
        }
        return gson.toJson((JsonElement)report).getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] create(JsonObject report, Interface itf) {
        try {
            byte[] resultsInJson = DashboardHelper.getReport(report, itf);
            byte[] template = DashboardHelper.getHTML();
            int placeholderStart = DashboardHelper.placeholderStart(template);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(Arrays.copyOfRange(template, 0, placeholderStart));
            stream.write(resultsInJson);
            stream.write(Arrays.copyOfRange(template, placeholderStart + placeholder.length, template.length));
            return stream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to generate dashboard");
        }
    }
}

