/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.traces.events.validation;

import com.google.common.base.Objects;
import java.util.Iterator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignatureDefinition;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.traces.events.traceEvents.Event;
import org.eclipse.comma.traces.events.traceEvents.Import;
import org.eclipse.comma.traces.events.traceEvents.Notification;
import org.eclipse.comma.traces.events.traceEvents.Reply;
import org.eclipse.comma.traces.events.traceEvents.Signal;
import org.eclipse.comma.traces.events.traceEvents.TraceEventsPackage;
import org.eclipse.comma.traces.events.validation.AbstractTraceEventsValidator;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TraceEventsValidator
extends AbstractTraceEventsValidator {
    @Check
    public void checkImportForValidity(Import imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", imp, (EStructuralFeature)TraceEventsPackage.eINSTANCE.getImport_ImportURI());
        } else {
            boolean _not_1;
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            EObject _head = (EObject)IteratorExtensions.head((Iterator)r.getAllContents());
            boolean bl2 = _not_1 = !(_head instanceof InterfaceSignatureDefinition);
            if (_not_1) {
                this.error("The imported resource is not an interface signature definition.", imp, (EStructuralFeature)TraceEventsPackage.eINSTANCE.getImport_ImportURI());
            }
        }
    }

    @Check
    public void checkNumberOfParameters(Event e) {
        boolean _notEquals;
        if (e == null) {
            return;
        }
        int expectedNrParams = 0;
        if (e instanceof org.eclipse.comma.traces.events.traceEvents.Command) {
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter p) {
                    DIRECTION _direction = p.getDirection();
                    return !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                }
            };
            expectedNrParams = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((org.eclipse.comma.traces.events.traceEvents.Command)e).getCommand().getParameters(), (Functions.Function1)_function));
        } else if (e instanceof Signal || e instanceof Notification) {
            expectedNrParams = e.getCommand().getParameters().size();
        } else if (e instanceof Reply) {
            boolean _not_1;
            boolean _not;
            Functions.Function1<Parameter, Boolean> _function_1 = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter p) {
                    DIRECTION _direction = p.getDirection();
                    return !Objects.equal((Object)_direction, (Object)DIRECTION.IN);
                }
            };
            expectedNrParams = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((Reply)e).getCommand().getParameters(), (Functions.Function1)_function_1));
            InterfaceEvent _command = ((Reply)e).getCommand();
            boolean bl = _not = !(_command instanceof Command);
            if (_not) {
                return;
            }
            InterfaceEvent _command_1 = ((Reply)e).getCommand();
            Type retType = ((Command)_command_1).getType();
            boolean _isVoid = TypeUtilities.isVoid((Type)retType);
            boolean bl2 = _not_1 = !_isVoid;
            if (_not_1) {
                ++expectedNrParams;
            }
        }
        int _size = e.getParameters().size();
        boolean bl = _notEquals = expectedNrParams != _size;
        if (_notEquals) {
            this.error("Wrong number of parameters. Expected " + Integer.valueOf(expectedNrParams) + " parameters.", (EStructuralFeature)TraceEventsPackage.Literals.EVENT__COMMAND);
        }
    }
}

