/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import java.util.ListIterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.impl.block.factory.Procedures;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ReverseIterable<T>
extends AbstractLazyIterable<T> {
    private final ListIterable<T> adapted;

    public ReverseIterable(ListIterable<T> newAdapted) {
        this.adapted = newAdapted;
    }

    public static <T> ReverseIterable<T> adapt(ListIterable<T> listIterable) {
        return new ReverseIterable<T>(listIterable);
    }

    public void each(Procedure<? super T> procedure) {
        this.adapted.reverseForEach(procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.adapted.reverseForEach(Procedures.fromObjectIntProcedure(objectIntProcedure));
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.adapted.reverseForEach(Procedures.bind(procedure, parameter));
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public T getFirst() {
        return (T)this.adapted.getLast();
    }

    @Override
    public T getLast() {
        return (T)this.adapted.getFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public Iterator<T> iterator() {
        ListIterator listIterator = this.adapted.listIterator(this.adapted.size());
        return new ReverseIterator(listIterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseIterator<T>
    implements Iterator<T> {
        private final ListIterator<T> listIterator;

        private ReverseIterator(ListIterator<T> listIterator) {
            this.listIterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasPrevious();
        }

        @Override
        public T next() {
            return this.listIterator.previous();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
        }
    }
}

