/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.lazy.ChunkIterable;
import org.eclipse.collections.impl.lazy.CollectIterable;
import org.eclipse.collections.impl.lazy.CompositeIterable;
import org.eclipse.collections.impl.lazy.DistinctIterable;
import org.eclipse.collections.impl.lazy.DropIterable;
import org.eclipse.collections.impl.lazy.DropWhileIterable;
import org.eclipse.collections.impl.lazy.FlatCollectIterable;
import org.eclipse.collections.impl.lazy.LazyIterableAdapter;
import org.eclipse.collections.impl.lazy.RejectIterable;
import org.eclipse.collections.impl.lazy.SelectInstancesOfIterable;
import org.eclipse.collections.impl.lazy.SelectIterable;
import org.eclipse.collections.impl.lazy.TakeIterable;
import org.eclipse.collections.impl.lazy.TakeWhileIterable;
import org.eclipse.collections.impl.lazy.TapIterable;
import org.eclipse.collections.impl.lazy.ZipIterable;
import org.eclipse.collections.impl.lazy.ZipWithIndexIterable;

public final class LazyIterate {
    private static final LazyIterable<?> EMPTY_ITERABLE = Lists.immutable.empty().asLazy();

    private LazyIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> LazyIterable<T> adapt(Iterable<T> iterable) {
        return new LazyIterableAdapter<T>(iterable);
    }

    public static <T> LazyIterable<T> select(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new SelectIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> reject(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new RejectIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> selectInstancesOf(Iterable<?> iterable, Class<T> clazz) {
        return new SelectInstancesOfIterable<T>(iterable, clazz);
    }

    public static <T, V> LazyIterable<V> collect(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        return new CollectIterable<T, V>(iterable, function);
    }

    public static <T, V> LazyIterable<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function) {
        return new FlatCollectIterable(iterable, function);
    }

    public static <T, V> LazyIterable<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return LazyIterate.select(iterable, predicate).collect((Function)function);
    }

    public static <T> LazyIterable<T> take(Iterable<T> iterable, int count) {
        return new TakeIterable<T>(iterable, count);
    }

    public static <T> LazyIterable<T> drop(Iterable<T> iterable, int count) {
        return new DropIterable<T>(iterable, count);
    }

    public static <T> LazyIterable<T> takeWhile(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new TakeWhileIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> dropWhile(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new DropWhileIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> distinct(Iterable<T> iterable) {
        return new DistinctIterable<T>(iterable);
    }

    public static <T> LazyIterable<T> concatenate(Iterable<T> ... iterables) {
        return CompositeIterable.with(iterables);
    }

    public static <T> LazyIterable<T> empty() {
        return EMPTY_ITERABLE;
    }

    public static <A, B> LazyIterable<Pair<A, B>> zip(Iterable<A> as, Iterable<B> bs) {
        return new ZipIterable<A, B>(as, bs);
    }

    public static <T> LazyIterable<Pair<T, Integer>> zipWithIndex(Iterable<T> iterable) {
        return new ZipWithIndexIterable<T>(iterable);
    }

    public static <T> LazyIterable<RichIterable<T>> chunk(Iterable<T> iterable, int size) {
        return new ChunkIterable<T>(iterable, size);
    }

    public static <T> LazyIterable<T> tap(Iterable<T> iterable, Procedure<? super T> procedure) {
        return new TapIterable<T>(iterable, procedure);
    }
}

