/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableShortBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableShortEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableShortHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableShortSingletonBag;

public enum ImmutableShortBagFactoryImpl implements ImmutableShortBagFactory
{
    INSTANCE;


    @Override
    public ImmutableShortBag empty() {
        return ImmutableShortEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableShortBag of() {
        return this.empty();
    }

    @Override
    public ImmutableShortBag with() {
        return this.empty();
    }

    @Override
    public ImmutableShortBag of(short one) {
        return this.with(one);
    }

    @Override
    public ImmutableShortBag with(short one) {
        return new ImmutableShortSingletonBag(one);
    }

    @Override
    public ImmutableShortBag of(short ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableShortBag with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortHashBag.newBagWith(items);
    }

    @Override
    public ImmutableShortBag ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableShortBag withAll(ShortIterable items) {
        if (items instanceof ImmutableShortBag) {
            return (ImmutableShortBag)items;
        }
        return this.with(items.toArray());
    }
}

