/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableCharSet
extends AbstractMutableSet<Character>
implements MutableSet<Character> {
    private final MutableCharSet delegate;

    public BoxedMutableCharSet(MutableCharSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Character getFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character getLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void each(Procedure<? super Character> procedure) {
        this.delegate.each(procedure::value);
    }

    @Override
    public boolean add(Character item) {
        return this.delegate.add(item.charValue());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Character && this.delegate.contains(((Character)object).charValue());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Character && this.delegate.remove(((Character)object).charValue());
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public ParallelUnsortedSetIterable<Character> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public Iterator<Character> iterator() {
        return new BoxedPrimitiveCharSetIterator(this.delegate.charIterator());
    }

    private static final class BoxedPrimitiveCharSetIterator
    implements Iterator<Character> {
        private final MutableCharIterator delegate;

        private BoxedPrimitiveCharSetIterator(MutableCharIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Character next() {
            return Character.valueOf(this.delegate.next());
        }
    }
}

