/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.api.tuple.primitive.ByteObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseByteIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

final class ImmutableByteSingletonList
implements ImmutableByteList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte element1;

    ImmutableByteSingletonList(byte element) {
        this.element1 = element;
    }

    @Override
    public byte get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    @Override
    public byte getFirst() {
        return this.element1;
    }

    @Override
    public byte getLast() {
        return this.element1;
    }

    @Override
    public int indexOf(byte value) {
        return this.element1 == value ? 0 : -1;
    }

    @Override
    public int lastIndexOf(byte value) {
        return this.element1 == value ? 0 : -1;
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(ByteArrayList.newListWith(this.element1).byteIterator());
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public void forEachWithIndex(ByteIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    @Override
    public int count(BytePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public ImmutableByteList select(BytePredicate predicate) {
        return predicate.accept(this.element1) ? ByteArrayList.newListWith(this.element1).toImmutable() : new ByteArrayList().toImmutable();
    }

    @Override
    public ImmutableByteList reject(BytePredicate predicate) {
        return predicate.accept(this.element1) ? new ByteArrayList().toImmutable() : ByteArrayList.newListWith(this.element1).toImmutable();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public <V> ImmutableList<V> collect(ByteToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    @Override
    public long sum() {
        return this.element1;
    }

    @Override
    public byte max() {
        return this.element1;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.element1;
    }

    @Override
    public byte min() {
        return this.element1;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public byte[] toSortedArray() {
        return new byte[]{this.element1};
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.element1);
    }

    @Override
    public int binarySearch(byte value) {
        if (this.element1 == value) {
            return 0;
        }
        if (this.element1 < value) {
            return -2;
        }
        return -1;
    }

    @Override
    public long dotProduct(ByteList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return (long)this.element1 * (long)list.getFirst();
    }

    @Override
    public byte[] toArray() {
        return new byte[]{this.element1};
    }

    @Override
    public boolean contains(byte value) {
        return this.element1 == value;
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public LazyByteIterable asReversed() {
        return ReverseByteIterable.adapt(this);
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.element1);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.element1);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public ImmutableByteList toImmutable() {
        return this;
    }

    @Override
    public ImmutableByteSingletonList toReversed() {
        return this;
    }

    @Override
    public ImmutableByteList newWith(byte element) {
        return ByteLists.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableByteList newWithout(byte element) {
        return this.element1 == element ? ByteLists.immutable.with() : this;
    }

    @Override
    public ImmutableByteList newWithAll(ByteIterable elements) {
        ByteArrayList arrayList = ByteArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    @Override
    public ImmutableByteList newWithoutAll(ByteIterable elements) {
        return elements.contains(this.element1) ? ByteLists.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1, 0);
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with(this);
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ByteList)) {
            return false;
        }
        ByteList list = (ByteList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return this.element1 == list.get(0);
    }

    @Override
    public int hashCode() {
        return 31 + this.element1;
    }

    @Override
    public String toString() {
        return "[" + this.element1 + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableByteList distinct() {
        return this;
    }

    @Override
    public ImmutableByteList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    @Override
    public ImmutableList<ByteBytePair> zipByte(ByteIterable iterable) {
        if (iterable.isEmpty()) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with(PrimitiveTuples.pair(this.element1, iterable.byteIterator().next()));
    }

    @Override
    public <T> ImmutableList<ByteObjectPair<T>> zip(Iterable<T> iterable) {
        if (Iterate.isEmpty(iterable)) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with(PrimitiveTuples.pair(this.element1, Iterate.getFirst(iterable)));
    }
}

