/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.dataprovider;

import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;

public class ClippedCircularBufferDataProvider
extends CircularBufferDataProvider {
    private int clippingWindow;

    public ClippedCircularBufferDataProvider(boolean chronological, int bufferSize, int clippingWindow) {
        super(chronological);
        this.setBufferSize(bufferSize);
        this.setClippingWindow(clippingWindow);
    }

    public void setClippingWindow(int clippingWindow) {
        assert (clippingWindow > 0);
        assert (clippingWindow <= this.getSize());
        this.clippingWindow = clippingWindow;
    }

    public int getClippingWindow() {
        return this.clippingWindow;
    }

    @Override
    public Range getDataRange(boolean positiveOnly, boolean isXAxis) {
        Range range = null;
        if (this.getSize() > 0) {
            int lowerBound = 0;
            if (this.getSize() > this.clippingWindow && this.clippingWindow > 0) {
                lowerBound = this.getSize() - 1 - this.clippingWindow;
            }
            range = super.getDataRange(positiveOnly, isXAxis, lowerBound);
        }
        return range;
    }
}

