/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;

public abstract class AbstractProcessingInfo<T>
implements IProcessingInfo<T> {
    private List<IProcessingMessage> processingMessages = new ArrayList<IProcessingMessage>();
    private T processingResult;

    public AbstractProcessingInfo() {
    }

    public AbstractProcessingInfo(IProcessingInfo<T> processingInfo) {
        this();
        this.addMessages(processingInfo);
    }

    @Override
    public void addMessages(IProcessingInfo<?> processingInfo) {
        if (processingInfo != null && processingInfo != this) {
            for (IProcessingMessage message : processingInfo.getMessages()) {
                this.addMessage(message);
            }
        }
    }

    @Override
    public void addMessage(IProcessingMessage processingMessage) {
        this.processingMessages.add(processingMessage);
    }

    @Override
    public void addInfoMessage(String description, String message) {
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.INFO, description, message);
        this.addMessage(processingMessage);
    }

    @Override
    public void addWarnMessage(String description, String message) {
        this.addWarnMessage(description, message, "");
    }

    @Override
    public void addWarnMessage(String description, String message, String proposedSolution) {
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, description, message, proposedSolution);
        this.addMessage(processingMessage);
    }

    @Override
    public void addErrorMessage(String description, String message) {
        this.addErrorMessage(description, message, "");
    }

    @Override
    public void addErrorMessage(String description, String message, String proposedSolution) {
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, description, message, proposedSolution);
        this.addMessage(processingMessage);
    }

    @Override
    public List<IProcessingMessage> getMessages() {
        return this.processingMessages;
    }

    @Override
    public void setProcessingResult(T processingResult) {
        this.processingResult = processingResult;
    }

    @Override
    public T getProcessingResult() {
        return this.processingResult;
    }

    @Override
    public <V> V getProcessingResult(Class<V> type) throws TypeCastException {
        if (type.isInstance(this.processingResult)) {
            return (V)this.processingResult;
        }
        Class<?> actualClass = this.processingResult == null ? new Exception("NULL").getClass() : this.processingResult.getClass();
        throw this.createTypeCastException("Processing Info", actualClass, type);
    }

    @Override
    public boolean hasErrorMessages() {
        for (IProcessingMessage processingMessage : this.processingMessages) {
            if (!processingMessage.getMessageType().equals((Object)MessageType.ERROR)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarnMessages() {
        for (IProcessingMessage processingMessage : this.processingMessages) {
            if (!processingMessage.getMessageType().equals((Object)MessageType.WARN)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public TypeCastException createTypeCastException(String description, Class<?> actual, Class<?> expected) {
        String message = "Failed to cast from " + actual + " to " + expected;
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, description, message);
        this.addMessage(processingMessage);
        return new TypeCastException(message);
    }
}

