/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.history;

import java.util.Date;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.support.messages.SupportMessages;

public class EditInformation
implements IEditInformation {
    private Date date;
    private String description;
    private String editor;
    public static final String NO_DESCRIPTION = SupportMessages.INSTANCE().getMessage("labelNoDescription", new String[0]);
    public static final String NO_EDITOR = SupportMessages.INSTANCE().getMessage("labelNotAvailable", new String[0]);

    public EditInformation(String description) {
        this(new Date(), description, "");
    }

    public EditInformation(String description, String editor) {
        this(new Date(), description, editor);
    }

    public EditInformation(Date date, String description) {
        this(date, description, "");
    }

    public EditInformation(Date date, String description, String editor) {
        this.setDate(date);
        this.setDescription(description);
        this.setEditor(editor);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    private void setDate(Date date) {
        this.date = date == null ? new Date() : date;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        if (description == null) {
            description = NO_DESCRIPTION;
        }
        this.description = description;
    }

    @Override
    public String getEditor() {
        return this.editor;
    }

    private void setEditor(String editor) {
        if (editor == null) {
            editor = NO_EDITOR;
        }
        this.editor = editor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IEditInformation other = (IEditInformation)obj;
        return this.getDate().getTime() == other.getDate().getTime() && this.getDescription().equals(other.getDate()) && this.getEditor().equals(other.getEditor());
    }

    public int hashCode() {
        return 7 * this.date.hashCode() + 11 * this.description.hashCode() + 13 * this.editor.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("date=" + this.date);
        builder.append(",");
        builder.append("description=" + this.description);
        builder.append(",");
        builder.append("editor=" + this.editor);
        builder.append("]");
        return builder.toString();
    }
}

