/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.executor.CacheMapManager;

public class CacheIDFetcher {
    private static CacheIDFetcher instance = null;
    private static long idleTime = 3600000L;
    private Map<String, Long> activeCacheIDs = new ConcurrentHashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheIDFetcher getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<CacheIDFetcher> clazz = CacheIDFetcher.class;
        synchronized (CacheIDFetcher.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new CacheIDFetcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CacheIDFetcher() {
        Timer timer = new Timer(true);
        CacheIDPurgeTimeTask task = new CacheIDPurgeTimeTask();
        timer.schedule((TimerTask)task, 0L, idleTime);
    }

    public String getCacheID(Map appContext) {
        block6: {
            block5: {
                try {
                    if (appContext != null) break block5;
                    return null;
                }
                catch (Exception exception) {}
            }
            Object option = appContext.get(DataEngine.MEMORY_DATA_SET_CACHE);
            if (option != null) break block6;
            return null;
        }
        Object o = appContext.get(DataEngine.QUERY_EXECUTION_SESSION_ID);
        if (o != null) {
            String cacheID = o.toString();
            this.activeCacheIDs.put(cacheID, System.currentTimeMillis());
            return cacheID;
        }
        return null;
    }

    public boolean enableSampleDataPreivew(Map appContext) {
        block6: {
            block5: {
                try {
                    if (appContext != null) break block5;
                    return false;
                }
                catch (Exception exception) {}
            }
            Object option = appContext.get(DataEngine.MEMORY_DATA_SET_CACHE);
            if (option != null) break block6;
            return false;
        }
        Object o = appContext.get(DataEngine.QUERY_EXECUTION_SESSION_ENABLE_SAMPLEDATAPREVIEW);
        if (o != null) {
            Boolean enableSamplePreivew = Boolean.valueOf(o.toString());
            return enableSamplePreivew;
        }
        return false;
    }

    private class CacheIDPurgeTimeTask
    extends TimerTask {
        private CacheIDPurgeTimeTask() {
        }

        @Override
        public void run() {
            String[] keyArray;
            HashSet<String> inActiveCacheIDs = new HashSet<String>();
            long currentTime = System.currentTimeMillis();
            String[] stringArray = keyArray = CacheIDFetcher.this.activeCacheIDs.keySet().toArray(new String[0]);
            int n = keyArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cacheID = stringArray[n2];
                long lastAccessTime = (Long)CacheIDFetcher.this.activeCacheIDs.get(cacheID);
                if (currentTime - lastAccessTime > idleTime) {
                    inActiveCacheIDs.add(cacheID);
                }
                ++n2;
            }
            CacheMapManager.clearCache(inActiveCacheIDs);
            for (String cacheID : inActiveCacheIDs) {
                CacheIDFetcher.this.activeCacheIDs.remove(cacheID);
            }
        }
    }
}

