/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.wsd.ui.views;

import java.io.File;
import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.ChromatogramOverviewUI;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ChromatogramOverviewView {
    private static final Logger logger = Logger.getLogger(ChromatogramOverviewView.class);
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private ChromatogramOverviewUI chromatogramOverviewUI;

    @Inject
    public ChromatogramOverviewView(Composite parent, IEventBroker eventBroker) {
        this.chromatogramOverviewUI = new ChromatogramOverviewUI(parent, 0);
        if (eventBroker != null) {
            EventHandler eventHandlerFileOverview = new EventHandler(){

                public void handleEvent(Event event) {
                    try {
                        Object object = event.getProperty("org.eclipse.e4.data");
                        if (object instanceof File) {
                            ChromatogramOverviewView.this.setChromatogram((File)object);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                }
            };
            eventBroker.subscribe("chromatogram/wsd/update/rawfile", eventHandlerFileOverview);
            EventHandler eventHandlerInstanceOverview = new EventHandler(){

                public void handleEvent(Event event) {
                    try {
                        Object object = event.getProperty("org.eclipse.e4.data");
                        if (object instanceof IChromatogramOverview) {
                            IChromatogramOverview chromatogramOverview = (IChromatogramOverview)object;
                            ChromatogramOverviewView.this.updateChromatogram(chromatogramOverview);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                }
            };
            eventBroker.subscribe("chromatogram/wsd/update/overview", eventHandlerInstanceOverview);
        }
    }

    @Focus
    public void setFocus() {
        this.chromatogramOverviewUI.setFocus();
    }

    private void updateChromatogram(IChromatogramOverview chromatogramOverview) {
        if (this.partService.isPartVisible(this.part) && chromatogramOverview != null) {
            this.chromatogramOverviewUI.showChromatogramOverview(chromatogramOverview);
        }
    }

    private void setChromatogram(File file) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException {
        if (this.partService.isPartVisible(this.part)) {
            IChromatogramOverviewImportConverterProcessingInfo processingInfo = ChromatogramConverterWSD.convertOverview((File)file, (IProgressMonitor)new NullProgressMonitor());
            try {
                IChromatogramOverview chromatogramOverview = processingInfo.getChromatogramOverview();
                if (chromatogramOverview != null) {
                    this.updateChromatogram(chromatogramOverview);
                }
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
    }
}

