/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.statistics;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.inference.OneWayAnova;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.INamedScanMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.statistics.StatisticsInputTypes;
import org.eclipse.chemclipse.numeric.statistics.model.AnovaStatistics;
import org.eclipse.chemclipse.numeric.statistics.model.IAnovaStatistics;
import org.eclipse.chemclipse.numeric.statistics.model.IStatistics;
import org.eclipse.chemclipse.numeric.statistics.model.IStatisticsElement;
import org.eclipse.chemclipse.numeric.statistics.model.StatisticsElement;
import org.eclipse.chemclipse.numeric.statistics.model.UnivariateStatistics;

public class StatisticsCalculator {
    public IStatisticsElement<IScanMSD> calculateStatistics(List<IScanMSD> massSpectra, StatisticsInputTypes id) {
        StatisticsElement statisticsElementRoot = new StatisticsElement((Object)"RootElement", massSpectra);
        int capacity = massSpectra.size();
        HashMap mzAbundances = new HashMap();
        switch (id) {
            case STATISTICS_ABUNDANCE: {
                for (IScanMSD massSpectrum : massSpectra) {
                    for (IIon ion : massSpectrum.getIons()) {
                        double mz = ion.getIon();
                        if (mzAbundances.containsKey(mz)) {
                            ((List)mzAbundances.get(mz)).add(ion);
                            continue;
                        }
                        ArrayList<IIon> ions = new ArrayList<IIon>(capacity);
                        ions.add(ion);
                        mzAbundances.put(mz, ions);
                    }
                }
                break;
            }
        }
        ArrayList<StatisticsElement> statisticsElements = new ArrayList<StatisticsElement>();
        for (Double mz : mzAbundances.keySet()) {
            switch (id) {
                case STATISTICS_ABUNDANCE: {
                    List ions = (List)mzAbundances.get(mz);
                    StatisticsElement statisticsElementLeaf = new StatisticsElement((Object)mz, ions);
                    int sampleSize = ions.size();
                    double[] abundances = new double[sampleSize];
                    int i = 0;
                    while (i < sampleSize) {
                        abundances[i] = ((IIon)ions.get(i)).getAbundance();
                        ++i;
                    }
                    UnivariateStatistics statistics = new UnivariateStatistics(abundances);
                    statisticsElementLeaf.setStatisticsContent((IStatistics)statistics);
                    statisticsElements.add(statisticsElementLeaf);
                    break;
                }
            }
        }
        statisticsElementRoot.setStatisticsElements(statisticsElements);
        return statisticsElementRoot;
    }

    public IStatisticsElement<IScanMSD> calculateInputForOneWayAnova(List<INamedScanMSD> groupedMassSpectra, StatisticsInputTypes id) {
        List ions;
        ArrayList<INamedScanMSD> massSpectra = new ArrayList<INamedScanMSD>();
        for (INamedScanMSD groupedMassSpectrum : groupedMassSpectra) {
            massSpectra.add(groupedMassSpectrum);
        }
        StatisticsElement statisticsElementRoot = new StatisticsElement((Object)"RootElement", massSpectra);
        HashMap mzSubstancesAbundances = new HashMap();
        block10: for (INamedScanMSD groupedMassSpectrum : groupedMassSpectra) {
            switch (id) {
                case ANOVA_ABUNDANCE: {
                    String substance = groupedMassSpectrum.getSubstanceName();
                    for (IIon ion : groupedMassSpectrum.getIons()) {
                        double mz = ion.getIon();
                        if (mzSubstancesAbundances.containsKey(mz)) {
                            if (((Map)mzSubstancesAbundances.get(mz)).containsKey(substance)) {
                                ((List)((Map)mzSubstancesAbundances.get(mz)).get(substance)).add(ion);
                                continue;
                            }
                            ions = new ArrayList<IIon>();
                            ions.add(ion);
                            ((Map)mzSubstancesAbundances.get(mz)).put(substance, ions);
                            continue;
                        }
                        HashMap substancesAbundances = new HashMap();
                        ArrayList<IIon> ions2 = new ArrayList<IIon>();
                        ions2.add(ion);
                        substancesAbundances.put(substance, ions2);
                        mzSubstancesAbundances.put(mz, substancesAbundances);
                    }
                    continue block10;
                }
            }
        }
        ArrayList<StatisticsElement> substanceStatisticsElements = new ArrayList<StatisticsElement>();
        for (Map.Entry entry : mzSubstancesAbundances.entrySet()) {
            switch (id) {
                case ANOVA_ABUNDANCE: {
                    Double mz = (Double)entry.getKey();
                    ArrayList<StatisticsElement> statisticsElements = new ArrayList<StatisticsElement>();
                    for (String substance : ((Map)entry.getValue()).keySet()) {
                        ions = (List)((Map)entry.getValue()).get(substance);
                        StatisticsElement statisticsElementLeaf = new StatisticsElement((Object)substance, ions);
                        int size = ions.size();
                        if (size <= 1) continue;
                        statisticsElements.add(statisticsElementLeaf);
                    }
                    int statisticsElementsSize = statisticsElements.size();
                    if (statisticsElementsSize <= 1) break;
                    StatisticsElement substanceStatisticsElement = new StatisticsElement((Object)mz, statisticsElements);
                    try {
                        Method getdata = IIon.class.getMethod("getAbundance", new Class[0]);
                        AnovaStatistics statistics = new AnovaStatistics((IStatisticsElement)substanceStatisticsElement, getdata);
                        substanceStatisticsElement.setStatisticsContent((IStatistics)statistics);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    substanceStatisticsElements.add(substanceStatisticsElement);
                    break;
                }
            }
        }
        statisticsElementRoot.setStatisticsElements(substanceStatisticsElements);
        return statisticsElementRoot;
    }

    public Map<Double, Collection<double[]>> calculateInputForOneWayAnovaOLD(List<INamedScanMSD> groupedMassSpectra) {
        HashMap mzSubstancesAbundances = new HashMap();
        for (INamedScanMSD groupedMassSpectrum : groupedMassSpectra) {
            String substance = groupedMassSpectrum.getSubstanceName();
            for (IIon ion : groupedMassSpectrum.getIons()) {
                double mz = ion.getIon();
                double abundance = ion.getAbundance();
                if (mzSubstancesAbundances.containsKey(mz)) {
                    if (((Map)mzSubstancesAbundances.get(mz)).containsKey(substance)) {
                        ((List)((Map)mzSubstancesAbundances.get(mz)).get(substance)).add(abundance);
                        continue;
                    }
                    ArrayList<Double> abundances = new ArrayList<Double>();
                    abundances.add(abundance);
                    ((Map)mzSubstancesAbundances.get(mz)).put(substance, abundances);
                    continue;
                }
                HashMap substancesAbundances = new HashMap();
                ArrayList<Double> abundances = new ArrayList<Double>();
                abundances.add(abundance);
                substancesAbundances.put(substance, abundances);
                mzSubstancesAbundances.put(mz, substancesAbundances);
            }
        }
        HashMap<Double, Collection<double[]>> mzAnovaInputPairs = new HashMap<Double, Collection<double[]>>();
        for (Map.Entry entry : mzSubstancesAbundances.entrySet()) {
            Double mz = (Double)entry.getKey();
            ArrayList<double[]> anovaInput = new ArrayList<double[]>();
            for (String substance : ((Map)entry.getValue()).keySet()) {
                List valuesList = (List)((Map)entry.getValue()).get(substance);
                int size = valuesList.size();
                if (size <= 1) continue;
                double[] values = new double[size];
                int i = 0;
                while (i < size) {
                    values[i] = (Double)valuesList.get(i);
                    ++i;
                }
                anovaInput.add(values);
            }
            if (anovaInput.size() <= 1) continue;
            mzAnovaInputPairs.put(mz, anovaInput);
        }
        return mzAnovaInputPairs;
    }

    public Map<Double, Double> calculateAnovaFValuesOld(Map<Double, Collection<double[]>> mzAnovaInputPairs) {
        OneWayAnova anova = new OneWayAnova();
        HashMap<Double, Double> mzAnovaFPairs = new HashMap<Double, Double>();
        for (Map.Entry<Double, Collection<double[]>> mzAnovaInputPair : mzAnovaInputPairs.entrySet()) {
            Double mz = mzAnovaInputPair.getKey();
            double fvalue = anova.anovaFValue(mzAnovaInputPair.getValue());
            mzAnovaFPairs.put(mz, fvalue);
        }
        return mzAnovaFPairs;
    }

    public Map<Double, Double> calculateAnovaFValues(IStatisticsElement<IScanMSD> anovaStatistics) {
        Map<Double, IAnovaStatistics> mzStatisticsPairs = this.getMzStatisticsPairs(anovaStatistics);
        HashMap<Double, Double> mzAnovaFPairs = new HashMap<Double, Double>();
        for (Map.Entry<Double, IAnovaStatistics> mzAnovaInputPair : mzStatisticsPairs.entrySet()) {
            Double mz = mzAnovaInputPair.getKey();
            double fvalue = mzAnovaInputPair.getValue().getFValue();
            mzAnovaFPairs.put(mz, fvalue);
        }
        return mzAnovaFPairs;
    }

    public Map<Double, Double> calculateAnovaPValues(IStatisticsElement<IScanMSD> anovaStatistics) {
        Map<Double, IAnovaStatistics> mzStatisticsPairs = this.getMzStatisticsPairs(anovaStatistics);
        HashMap<Double, Double> mzAnovaPPairs = new HashMap<Double, Double>();
        for (Map.Entry<Double, IAnovaStatistics> mzAnovaInputPair : mzStatisticsPairs.entrySet()) {
            Double mz = mzAnovaInputPair.getKey();
            double fvalue = mzAnovaInputPair.getValue().getPValue();
            mzAnovaPPairs.put(mz, fvalue);
        }
        return mzAnovaPPairs;
    }

    public Map<Double, IAnovaStatistics> calculateAnovaStatistics(IStatisticsElement<?> anovaStatistics) {
        return this.getMzStatisticsPairs(anovaStatistics);
    }

    private Map<Double, IAnovaStatistics> getMzStatisticsPairs(IStatisticsElement<?> anovaStatistics) {
        HashMap<Double, IAnovaStatistics> mzStatisticsPairs = new HashMap<Double, IAnovaStatistics>();
        for (IStatisticsElement elem : anovaStatistics.getStatisticsElements()) {
            Double mz = (Double)elem.getIdentifier();
            IAnovaStatistics value = (IAnovaStatistics)elem.getStatisticsContent();
            mzStatisticsPairs.put(mz, value);
        }
        return mzStatisticsPairs;
    }
}

