/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.support;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IIonPercentages;

public class IonPercentages
implements IIonPercentages {
    private IScanMSD massSpectrum;
    private SortedMap<Integer, Float> ionDistribution;

    public IonPercentages(IScanMSD massSpectrum) {
        this.massSpectrum = massSpectrum;
        this.ionDistribution = new TreeMap<Integer, Float>();
        this.setIonDistribution();
    }

    @Override
    public IScanMSD getMassSpectrum() {
        return this.massSpectrum;
    }

    @Override
    public float getPercentage(int ion) {
        float result = 0.0f;
        if (this.massSpectrumIsNull()) {
            result = 0.0f;
        } else if (this.ionDistribution.containsKey(ion)) {
            result = ((Float)this.ionDistribution.get(ion)).floatValue();
        }
        return result;
    }

    @Override
    public float getPercentage(List<Integer> ions) {
        float result = 0.0f;
        if (ions != null) {
            for (Integer ion : ions) {
                result += this.getPercentage(ion);
            }
        }
        return result;
    }

    private void setIonDistribution() {
        if (!this.massSpectrumIsNull()) {
            float totalIonSignal = this.massSpectrum.getTotalSignal();
            if (totalIonSignal == 0.0f) {
                return;
            }
            float factor = 100.0f / totalIonSignal;
            for (IIon actualIon : this.massSpectrum.getIons()) {
                if (actualIon == null) continue;
                float percentage = factor * actualIon.getAbundance();
                int ion = AbstractIon.getIon(actualIon.getIon());
                this.ionDistribution.put(ion, Float.valueOf(percentage));
            }
        }
    }

    private boolean massSpectrumIsNull() {
        boolean result = false;
        if (this.massSpectrum == null) {
            result = true;
        }
        return result;
    }
}

