/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.AbstractSimplex;

public class NelderMeadSimplex
extends AbstractSimplex {
    private static final double DEFAULT_RHO = 1.0;
    private static final double DEFAULT_KHI = 2.0;
    private static final double DEFAULT_GAMMA = 0.5;
    private static final double DEFAULT_SIGMA = 0.5;
    private final double rho;
    private final double khi;
    private final double gamma;
    private final double sigma;

    public NelderMeadSimplex(int n) {
        this(n, 1.0);
    }

    public NelderMeadSimplex(int n, double sideLength) {
        this(n, sideLength, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(int n, double sideLength, double rho, double khi, double gamma, double sigma) {
        super(n, sideLength);
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    public NelderMeadSimplex(int n, double rho, double khi, double gamma, double sigma) {
        this(n, 1.0, rho, khi, gamma, sigma);
    }

    public NelderMeadSimplex(double[] steps) {
        this(steps, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(double[] steps, double rho, double khi, double gamma, double sigma) {
        super(steps);
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    public NelderMeadSimplex(double[][] referenceSimplex) {
        this(referenceSimplex, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(double[][] referenceSimplex, double rho, double khi, double gamma, double sigma) {
        super(referenceSimplex);
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    @Override
    public void iterate(MultivariateFunction evaluationFunction, Comparator<PointValuePair> comparator) {
        int j;
        int n = this.getDimension();
        PointValuePair best = this.getPoint(0);
        PointValuePair secondBest = this.getPoint(n - 1);
        PointValuePair worst = this.getPoint(n);
        double[] xWorst = worst.getPointRef();
        double[] centroid = new double[n];
        int i = 0;
        while (i < n) {
            double[] x = this.getPoint(i).getPointRef();
            j = 0;
            while (j < n) {
                int n2 = j;
                centroid[n2] = centroid[n2] + x[j];
                ++j;
            }
            ++i;
        }
        double scaling = 1.0 / (double)n;
        j = 0;
        while (j < n) {
            int n3 = j++;
            centroid[n3] = centroid[n3] * scaling;
        }
        double[] xR = new double[n];
        int j2 = 0;
        while (j2 < n) {
            xR[j2] = centroid[j2] + this.rho * (centroid[j2] - xWorst[j2]);
            ++j2;
        }
        PointValuePair reflected = new PointValuePair(xR, evaluationFunction.value(xR), false);
        if (comparator.compare(best, reflected) <= 0 && comparator.compare(reflected, secondBest) < 0) {
            this.replaceWorstPoint(reflected, comparator);
        } else if (comparator.compare(reflected, best) < 0) {
            double[] xE = new double[n];
            int j3 = 0;
            while (j3 < n) {
                xE[j3] = centroid[j3] + this.khi * (xR[j3] - centroid[j3]);
                ++j3;
            }
            PointValuePair expanded = new PointValuePair(xE, evaluationFunction.value(xE), false);
            if (comparator.compare(expanded, reflected) < 0) {
                this.replaceWorstPoint(expanded, comparator);
            } else {
                this.replaceWorstPoint(reflected, comparator);
            }
        } else {
            double[] xC;
            if (comparator.compare(reflected, worst) < 0) {
                xC = new double[n];
                int j4 = 0;
                while (j4 < n) {
                    xC[j4] = centroid[j4] + this.gamma * (xR[j4] - centroid[j4]);
                    ++j4;
                }
                PointValuePair outContracted = new PointValuePair(xC, evaluationFunction.value(xC), false);
                if (comparator.compare(outContracted, reflected) <= 0) {
                    this.replaceWorstPoint(outContracted, comparator);
                    return;
                }
            } else {
                xC = new double[n];
                int j5 = 0;
                while (j5 < n) {
                    xC[j5] = centroid[j5] - this.gamma * (centroid[j5] - xWorst[j5]);
                    ++j5;
                }
                PointValuePair inContracted = new PointValuePair(xC, evaluationFunction.value(xC), false);
                if (comparator.compare(inContracted, worst) < 0) {
                    this.replaceWorstPoint(inContracted, comparator);
                    return;
                }
            }
            double[] xSmallest = this.getPoint(0).getPointRef();
            int i2 = 1;
            while (i2 <= n) {
                double[] x = this.getPoint(i2).getPoint();
                int j6 = 0;
                while (j6 < n) {
                    x[j6] = xSmallest[j6] + this.sigma * (x[j6] - xSmallest[j6]);
                    ++j6;
                }
                this.setPoint(i2, new PointValuePair(x, Double.NaN, false));
                ++i2;
            }
            this.evaluate(evaluationFunction, comparator);
        }
    }
}

