/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.IMassSpectrumComparatorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.IPeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.IVendorMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.IVendorPeakIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.DatabasesCache;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.PenaltyCalculationSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.TargetBuilder;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.comparator.TargetCombinedComparator;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.IPeakIdentificationResults;
import org.eclipse.chemclipse.model.identifier.PeakIdentificationResults;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileIdentifier {
    public static final String IDENTIFIER = "File Identifier";
    private static final Logger logger = Logger.getLogger(FileIdentifier.class);
    private TargetCombinedComparator targetCombinedComparator = new TargetCombinedComparator(SortOrder.DESC);
    private TargetBuilder targetBuilder = new TargetBuilder();
    private DatabasesCache databasesCache = new DatabasesCache(PreferenceSupplier.getMassSpectraFiles());

    public IMassSpectra runIdentification(List<IScanMSD> massSpectraList, IVendorMassSpectrumIdentifierSettings fileIdentifierSettings, IProgressMonitor monitor) throws FileNotFoundException {
        MassSpectra massSpectra = new MassSpectra();
        massSpectra.addMassSpectra(massSpectraList);
        String identifier = IDENTIFIER;
        String alternateIdentifierId = fileIdentifierSettings.getAlternateIdentifierId();
        if (!alternateIdentifierId.equals("")) {
            identifier = alternateIdentifierId;
        }
        Map databases = this.databasesCache.getDatabases(fileIdentifierSettings.getMassSpectraFiles(), monitor);
        for (Map.Entry<String, IMassSpectra> entry : databases.entrySet()) {
            this.compareMassSpectraAgainstDatabase((IMassSpectra)massSpectra, fileIdentifierSettings, identifier, entry, monitor);
        }
        for (IScanMSD iScanMSD : massSpectra.getList()) {
            List massSpectrumTargets = iScanMSD.getTargets();
            if (massSpectrumTargets.size() != 0 || !fileIdentifierSettings.isAddUnknownMzListTarget()) continue;
            this.targetBuilder.setMassSpectrumTargetUnknown(iScanMSD, identifier);
        }
        return massSpectra;
    }

    public IPeakIdentificationResults runPeakIdentification(List<IPeakMSD> peaks, IVendorPeakIdentifierSettings peakIdentifierSettings, IPeakIdentifierProcessingInfo processingInfo, IProgressMonitor monitor) throws FileNotFoundException {
        PeakIdentificationResults identificationResults = new PeakIdentificationResults();
        String identifier = IDENTIFIER;
        String alternateIdentifierId = peakIdentifierSettings.getAlternateIdentifierId();
        if (!alternateIdentifierId.equals("")) {
            identifier = alternateIdentifierId;
        }
        Map databases = this.databasesCache.getDatabases(peakIdentifierSettings.getMassSpectraFiles(), monitor);
        for (Map.Entry<String, IMassSpectra> entry : databases.entrySet()) {
            this.comparePeaksAgainstDatabase(peakIdentifierSettings, peaks, identifier, entry, monitor);
        }
        for (IPeakMSD iPeakMSD : peaks) {
            if (iPeakMSD.getTargets().size() != 0 || !peakIdentifierSettings.isAddUnknownMzListTarget()) continue;
            this.targetBuilder.setPeakTargetUnknown(iPeakMSD, identifier);
        }
        return identificationResults;
    }

    public IMassSpectra getMassSpectra(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        String identifier;
        MassSpectra massSpectra = new MassSpectra();
        if (identificationTarget != null && ((identifier = identificationTarget.getIdentifier()).equals(IDENTIFIER) || identifier.equals(""))) {
            massSpectra.addMassSpectra((Collection)this.databasesCache.getDatabaseMassSpectra(identificationTarget, monitor));
        }
        return massSpectra;
    }

    private void compareMassSpectraAgainstDatabase(IMassSpectra massSpectra, IVendorMassSpectrumIdentifierSettings fileIdentifierSettings, String identifier, Map.Entry<String, IMassSpectra> database, IProgressMonitor monitor) {
        String databaseName = database.getKey();
        List references = database.getValue().getList();
        boolean usePreOptimization = fileIdentifierSettings.isUsePreOptimization();
        double thresholdPreOptimization = fileIdentifierSettings.getThresholdPreOptimization();
        int countUnknown = 1;
        for (IScanMSD unknown : massSpectra.getList()) {
            if (monitor.isCanceled()) {
                return;
            }
            ArrayList<IMassSpectrumTarget> massSpectrumTargets = new ArrayList<IMassSpectrumTarget>();
            int index = 0;
            while (index < references.size()) {
                try {
                    monitor.subTask("Compare " + countUnknown);
                    IScanMSD reference = (IScanMSD)references.get(index);
                    IMassSpectrumComparatorProcessingInfo infoCompare = MassSpectrumComparator.compare((IScanMSD)unknown, (IScanMSD)reference, (String)fileIdentifierSettings.getMassSpectrumComparatorId(), (boolean)usePreOptimization, (double)thresholdPreOptimization);
                    IMassSpectrumComparisonResult comparisonResult = infoCompare.getMassSpectrumComparisonResult();
                    this.applyPenaltyOnDemand(unknown, reference, (IComparisonResult)comparisonResult, (IIdentifierSettings)fileIdentifierSettings);
                    if (this.isValidTarget((IComparisonResult)comparisonResult, fileIdentifierSettings.getMinMatchFactor(), fileIdentifierSettings.getMinReverseMatchFactor())) {
                        IMassSpectrumTarget massSpectrumTarget = this.targetBuilder.getMassSpectrumTarget(reference, comparisonResult, identifier, databaseName);
                        massSpectrumTargets.add(massSpectrumTarget);
                    }
                }
                catch (TypeCastException e1) {
                    logger.warn((Object)e1);
                }
                ++index;
            }
            if (massSpectrumTargets.size() > 0) {
                Collections.sort(massSpectrumTargets, this.targetCombinedComparator);
                int numberOfTargets = fileIdentifierSettings.getNumberOfTargets();
                int size = numberOfTargets <= massSpectrumTargets.size() ? numberOfTargets : massSpectrumTargets.size();
                int i = 0;
                while (i < size) {
                    unknown.addTarget((IMassSpectrumTarget)massSpectrumTargets.get(i));
                    ++i;
                }
            }
            ++countUnknown;
        }
    }

    private void comparePeaksAgainstDatabase(IVendorPeakIdentifierSettings fileIdentifierSettings, List<IPeakMSD> peaks, String identifier, Map.Entry<String, IMassSpectra> database, IProgressMonitor monitor) {
        String databaseName = database.getKey();
        List references = database.getValue().getList();
        boolean usePreOptimization = fileIdentifierSettings.isUsePreOptimization();
        double thresholdPreOptimization = fileIdentifierSettings.getThresholdPreOptimization();
        int countUnknown = 1;
        for (IPeakMSD peakMSD : peaks) {
            if (monitor.isCanceled()) {
                return;
            }
            ArrayList<IPeakTarget> peakTargets = new ArrayList<IPeakTarget>();
            IPeakMassSpectrum unknown = peakMSD.getPeakModel().getPeakMassSpectrum();
            int index = 0;
            while (index < references.size()) {
                try {
                    monitor.subTask("Compare " + countUnknown);
                    IScanMSD reference = (IScanMSD)references.get(index);
                    IMassSpectrumComparatorProcessingInfo infoCompare = MassSpectrumComparator.compare((IScanMSD)unknown, (IScanMSD)reference, (String)fileIdentifierSettings.getMassSpectrumComparatorId(), (boolean)usePreOptimization, (double)thresholdPreOptimization);
                    IMassSpectrumComparisonResult comparisonResult = infoCompare.getMassSpectrumComparisonResult();
                    this.applyPenaltyOnDemand((IScanMSD)unknown, reference, (IComparisonResult)comparisonResult, (IIdentifierSettings)fileIdentifierSettings);
                    if (this.isValidTarget((IComparisonResult)comparisonResult, fileIdentifierSettings.getMinMatchFactor(), fileIdentifierSettings.getMinReverseMatchFactor())) {
                        IPeakTarget peakTarget = this.targetBuilder.getPeakTarget(reference, comparisonResult, identifier, databaseName);
                        peakTargets.add(peakTarget);
                    }
                }
                catch (TypeCastException e1) {
                    logger.warn((Object)e1);
                }
                ++index;
            }
            if (peakTargets.size() > 0) {
                Collections.sort(peakTargets, this.targetCombinedComparator);
                int numberOfTargets = fileIdentifierSettings.getNumberOfTargets();
                int size = numberOfTargets <= peakTargets.size() ? numberOfTargets : peakTargets.size();
                int i = 0;
                while (i < size) {
                    peakMSD.addTarget((IPeakTarget)peakTargets.get(i));
                    ++i;
                }
            }
            ++countUnknown;
        }
    }

    private void applyPenaltyOnDemand(IScanMSD unknown, IScanMSD reference, IComparisonResult comparisonResult, IIdentifierSettings identifierSettings) {
        String penaltyCalculation;
        float penalty = 0.0f;
        switch (penaltyCalculation = identifierSettings.getPenaltyCalculation()) {
            case "RT": {
                penalty = PenaltyCalculationSupport.calculatePenaltyFromRetentionTime((int)unknown.getRetentionTime(), (int)reference.getRetentionTime(), (int)identifierSettings.getRetentionTimeWindow(), (float)identifierSettings.getPenaltyCalculationLevelFactor(), (float)identifierSettings.getMaxPenalty());
                break;
            }
            case "RI": {
                penalty = PenaltyCalculationSupport.calculatePenaltyFromRetentionIndex((IScanMSD)unknown, (IScanMSD)reference, (float)identifierSettings.getRetentionIndexWindow(), (float)identifierSettings.getPenaltyCalculationLevelFactor(), (float)identifierSettings.getMaxPenalty());
            }
        }
        if (penalty != 0.0f) {
            comparisonResult.setPenalty(penalty);
        }
    }

    private boolean isValidTarget(IComparisonResult comparisonResult, float minMatchFactor, float minReverseMatchFactor) {
        return comparisonResult.getMatchFactor() >= minMatchFactor && comparisonResult.getReverseMatchFactor() >= minReverseMatchFactor;
    }
}

