/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figureparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ColorMapRamp
extends Figure {
    private double min = 0.0;
    private double max = 1.0;
    private double[] mapData = new double[256];
    private ColorMap colorMap;
    private LinearScale scale;
    private ColorMapFigure colorMapFigure;
    private static final int RAMP_WIDTH = 25;

    public ColorMapRamp() {
        this.updateMapData();
        this.colorMap = new ColorMap(ColorMap.PredefinedColorMap.GrayScale, true, true);
        this.scale = new LinearScale();
        this.scale.setOrientation(LinearScale.Orientation.VERTICAL);
        this.scale.setScaleLineVisible(false);
        this.scale.setTickLableSide(AbstractScale.LabelSide.Secondary);
        this.scale.setMinorTicksVisible(false);
        this.scale.setRange(this.min, this.max);
        this.scale.setMajorTickMarkStepHint(50);
        this.colorMapFigure = new ColorMapFigure();
        this.add((IFigure)this.colorMapFigure);
        this.add((IFigure)this.scale);
    }

    private void updateMapData() {
        int j = 0;
        while (j < 256) {
            this.mapData[j] = this.max - (double)j * (this.max - this.min) / 255.0;
            ++j;
        }
    }

    protected void layout() {
        Rectangle clientArea = this.getClientArea();
        Dimension scaleSize = this.scale.getPreferredSize(clientArea.width, clientArea.height);
        this.scale.setBounds(new Rectangle(clientArea.x + clientArea.width - scaleSize.width, clientArea.y, scaleSize.width, clientArea.height));
        this.colorMapFigure.setBounds(new Rectangle(clientArea.x, this.scale.getValuePosition(this.max, false), clientArea.width - scaleSize.width, this.scale.getTickLength()));
        super.layout();
    }

    public Dimension getPreferredSize(int hint, int hint2) {
        Dimension result = super.getPreferredSize(hint, hint2);
        result.width = 25 + this.scale.getPreferredSize((int)hint, (int)hint2).width;
        return result;
    }

    public final void setMin(double min) {
        this.min = min;
        this.scale.setRange(min, this.max);
        this.updateMapData();
    }

    public final void setMax(double max) {
        this.max = max;
        this.scale.setRange(this.min, max);
        this.updateMapData();
    }

    public final void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.scale.setFont(f);
    }

    class ColorMapFigure
    extends Figure {
        ColorMapFigure() {
        }

        protected void paintClientArea(Graphics graphics) {
            super.paintClientArea(graphics);
            Rectangle clientArea = this.getClientArea();
            Image image = new Image((Device)Display.getCurrent(), ColorMapRamp.this.colorMap.drawImage(ColorMapRamp.this.mapData, 1, 256, ColorMapRamp.this.max, ColorMapRamp.this.min));
            graphics.drawImage(image, new Rectangle(image.getBounds()), clientArea);
            image.dispose();
        }
    }
}

