/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.views;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.swt.NoiseMassSpectraUI;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class InteractiveDenoisingFilterMassSpectrumView
extends AbstractChromatogramSelectionMSDView {
    private static final Logger logger = Logger.getLogger(InteractiveDenoisingFilterMassSpectrumView.class);
    @Inject
    private Composite parent;
    private NoiseMassSpectraUI noiseMassSpectraUI;

    @Inject
    public InteractiveDenoisingFilterMassSpectrumView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.subscribeToMassSpectraUpdates(eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.noiseMassSpectraUI = new NoiseMassSpectraUI(this.parent, 0);
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.noiseMassSpectraUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        this.doUpdate((IChromatogramSelection)chromatogramSelection);
    }

    public void update(List<ICombinedMassSpectrum> massSpectra, boolean forceReload) {
        if (this.isPartVisible() && massSpectra != null) {
            this.noiseMassSpectraUI.update(massSpectra, forceReload);
        }
    }

    private void subscribeToMassSpectraUpdates(IEventBroker eventBroker) {
        if (eventBroker != null) {
            EventHandler eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object instanceof List) {
                        try {
                            List elements = (List)object;
                            InteractiveDenoisingFilterMassSpectrumView.this.update(elements, true);
                        }
                        catch (Exception e) {
                            logger.warn((Object)e);
                        }
                    }
                }
            };
            eventBroker.subscribe("filter/msd/update/supplier/denoising/noisemassspectra", eventHandler);
        }
    }
}

