/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.converter.core.AbstractConverterSupport;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.ux.extension.ui.provider.IChromatogramIdentifier;

public abstract class AbstractChromatogramIdentifier
implements IChromatogramIdentifier {
    private List<ISupplier> suppliers;
    private Map<String, String> regularExpressions;

    public AbstractChromatogramIdentifier(List<ISupplier> suppliers) {
        this.suppliers = suppliers;
        this.regularExpressions = new HashMap<String, String>();
    }

    @Override
    public boolean isChromatogram(File file) {
        String extension = file.toString().toLowerCase();
        if (file.isDirectory()) {
            return false;
        }
        for (ISupplier supplier : this.suppliers) {
            String supplierExtension = supplier.getFileExtension().toLowerCase();
            if (supplierExtension == "") continue;
            if (supplierExtension.contains("#")) {
                String extensionMatcher = this.regularExpressions.get(supplierExtension);
                if (extensionMatcher == null) {
                    extensionMatcher = AbstractConverterSupport.getExtensionMatcher((String)supplierExtension);
                    this.regularExpressions.put(supplierExtension, extensionMatcher);
                }
                if (!extension.matches(extensionMatcher)) continue;
                return supplier.isImportable();
            }
            if (!extension.endsWith(supplierExtension)) continue;
            return supplier.isImportable();
        }
        return false;
    }

    @Override
    public boolean isChromatogramDirectory(File file) {
        String directory = file.toString().toUpperCase();
        if (!file.isDirectory()) {
            return false;
        }
        for (ISupplier supplier : this.suppliers) {
            String directoryExtension = supplier.getDirectoryExtension().toUpperCase();
            if (directoryExtension == "" || !directory.endsWith(directoryExtension) || !supplier.isImportable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchMagicNumber(File file) {
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.isMatchMagicNumber(file)) continue;
            return true;
        }
        return false;
    }
}

