/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.ui.modifier;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterMSD;
import org.eclipse.chemclipse.model.processor.AbstractChromatogramProcessor;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class FilterModifier
extends AbstractChromatogramProcessor
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "CODA Filter";
    private static final String FILTER_ID = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda";

    public FilterModifier(IChromatogramSelectionMSD chromatogramSelection) {
        super((IChromatogramSelection)chromatogramSelection);
    }

    public void execute(IProgressMonitor monitor) {
        if (this.getChromatogramSelection() instanceof IChromatogramSelectionMSD) {
            final IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)this.getChromatogramSelection();
            IChromatogramFilterProcessingInfo processingInfo = ChromatogramFilterMSD.applyFilter((IChromatogramSelectionMSD)chromatogramSelection, (String)FILTER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    chromatogramSelection.reset(true);
                }
            });
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            this.getChromatogramSelection().getChromatogram().doOperation((IChromatogramProcessor)this, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

