/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.views;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.ux.extension.xxd.ui.views.IChromatogramOverviewView;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractChromatogramOverviewView
implements IChromatogramOverviewView {
    private static final Logger logger = Logger.getLogger(AbstractChromatogramOverviewView.class);
    private MPart part;
    private EPartService partService;
    private IEventBroker eventBroker;
    private List<EventHandler> registeredEventHandler;

    public AbstractChromatogramOverviewView(MPart part, EPartService partService, IEventBroker eventBroker) {
        this.part = part;
        this.partService = partService;
        this.eventBroker = eventBroker;
        this.registeredEventHandler = new ArrayList<EventHandler>();
        this.registerEventBroker(eventBroker);
    }

    @Override
    public boolean doUpdate(IChromatogramOverview chromatogramOverview) {
        return this.partService.isPartVisible(this.part) && chromatogramOverview != null;
    }

    @PreDestroy
    private void preDestroy() {
        if (this.eventBroker != null) {
            for (EventHandler eventHandler : this.registeredEventHandler) {
                this.eventBroker.unsubscribe(eventHandler);
            }
        }
    }

    private void registerEventBroker(IEventBroker eventBroker) {
        if (eventBroker != null) {
            EventHandler eventHandler = this.registerEventHandlerFile(eventBroker, "org.eclipse.e4.data", "chromatogram/msd/update/rawfile");
            this.registeredEventHandler.add(eventHandler);
            eventHandler = this.registerEventHandlerFile(eventBroker, "org.eclipse.e4.data", "chromatogram/csd/update/rawfile");
            this.registeredEventHandler.add(eventHandler);
            eventHandler = this.registerEventHandlerFile(eventBroker, "org.eclipse.e4.data", "chromatogram/wsd/update/rawfile");
            this.registeredEventHandler.add(eventHandler);
            eventHandler = this.registerEventHandlerInstance(eventBroker, "org.eclipse.e4.data", "chromatogram/msd/update/overview");
            this.registeredEventHandler.add(eventHandler);
            eventHandler = this.registerEventHandlerInstance(eventBroker, "org.eclipse.e4.data", "chromatogram/csd/update/overview");
            this.registeredEventHandler.add(eventHandler);
            eventHandler = this.registerEventHandlerInstance(eventBroker, "org.eclipse.e4.data", "chromatogram/wsd/update/overview");
            this.registeredEventHandler.add(eventHandler);
        }
    }

    private EventHandler registerEventHandlerFile(IEventBroker eventBroker, final String property, final String topic) {
        EventHandler eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    Object object = event.getProperty(property);
                    if (object instanceof File) {
                        AbstractChromatogramOverviewView.this.setChromatogram((File)object, topic);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
            }
        };
        eventBroker.subscribe(topic, eventHandler);
        return eventHandler;
    }

    private EventHandler registerEventHandlerInstance(IEventBroker eventBroker, final String property, String topic) {
        EventHandler eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    Object object = event.getProperty(property);
                    if (object instanceof IChromatogramOverview) {
                        IChromatogramOverview chromatogramOverview = (IChromatogramOverview)object;
                        AbstractChromatogramOverviewView.this.updateChromatogram(chromatogramOverview);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
            }
        };
        eventBroker.subscribe(topic, eventHandler);
        return eventHandler;
    }

    private void setChromatogram(File file, String topic) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException {
        block16: {
            if (!this.partService.isPartVisible(this.part)) break block16;
            IChromatogramOverviewImportConverterProcessingInfo processingInfo = null;
            switch (topic) {
                case "chromatogram/msd/update/rawfile": {
                    processingInfo = ChromatogramConverterMSD.convertOverview((File)file, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case "chromatogram/csd/update/rawfile": {
                    processingInfo = ChromatogramConverterCSD.convertOverview((File)file, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case "chromatogram/wsd/update/rawfile": {
                    processingInfo = ChromatogramConverterWSD.convertOverview((File)file, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            try {
                IChromatogramOverview chromatogramOverview;
                if (processingInfo != null && (chromatogramOverview = processingInfo.getChromatogramOverview()) != null) {
                    this.updateChromatogram(chromatogramOverview);
                }
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
    }
}

