/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.handlers;

import javax.inject.Named;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteChromatogramIntegrationsHandler
implements EventHandler {
    private static IChromatogramSelection chromatogramSelection;

    @Execute
    public void execute(UISynchronize uiSynchronize, @Named(value="activeShell") Shell shell) {
        IChromatogram chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogram()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText("Delete Chromatogram Integration");
            messageBox.setMessage("Do you really want to delete the chromatogram integration values?");
            int decision = messageBox.open();
            if (64 == decision) {
                chromatogram.removeAllBackgroundIntegrationEntries();
                chromatogram.removeAllChromatogramIntegrationEntries();
                chromatogramSelection.update(true);
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        } else if (event.getTopic().equals("chromatogram/csd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection");
        }
    }
}

