/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.handlers;

import javax.inject.Named;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteAllPeakIntegrationsHandler
implements EventHandler {
    private static IChromatogramSelection chromatogramSelection;

    @Execute
    public void execute(UISynchronize uiSynchronize, @Named(value="activeShell") Shell shell) {
        IChromatogram chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogram()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText("Delete All Peak Integrations");
            messageBox.setMessage("Do you really want to delete all peak integration values?");
            int decision = messageBox.open();
            if (64 == decision) {
                if (chromatogramSelection instanceof ChromatogramSelectionMSD) {
                    ChromatogramSelectionMSD chromatogramSelectionMSD = (ChromatogramSelectionMSD)chromatogramSelection;
                    IChromatogramMSD chromatogramMSD = chromatogramSelectionMSD.getChromatogramMSD();
                    for (IChromatogramPeakMSD peak : chromatogramMSD.getPeaks()) {
                        peak.removeAllIntegrationEntries();
                    }
                    chromatogramSelectionMSD.update(true);
                } else if (chromatogramSelection instanceof ChromatogramSelectionCSD) {
                    ChromatogramSelectionCSD chromatogramSelectionFID = (ChromatogramSelectionCSD)chromatogramSelection;
                    IChromatogramCSD chromatogramFID = chromatogramSelectionFID.getChromatogramCSD();
                    for (IChromatogramPeakCSD peak : chromatogramFID.getPeaks()) {
                        peak.removeAllIntegrationEntries();
                    }
                    chromatogramSelectionFID.update(true);
                }
            }
        }
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/csd/update/chromatogramselection") ? (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/wsd/update/chromatogramselection") ? (IChromatogramSelectionWSD)event.getProperty("ChromatogramSelection") : null));
    }
}

