/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.ui.internal.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.internal.provider.ProcessingInfoContentProvider;
import org.eclipse.chemclipse.processing.ui.internal.provider.ProcessingInfoLabelProvider;
import org.eclipse.chemclipse.processing.ui.internal.provider.ProcessingInfoTableComparator;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ProcessingInfoUI {
    private TableViewer tableViewer;
    private ProcessingInfoTableComparator processingInfoTableComparator;
    private Clipboard clipboard;
    private String[] titles = new String[]{"Type", "Description", "Message", "Date"};
    private int[] bounds = new int[]{100, 100, 100, 100};
    private static final String DELIMITER = "\t";

    public ProcessingInfoUI(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        this.clipboard = new Clipboard(Display.getDefault());
        HashMap<Long, String> substances = new HashMap<Long, String>();
        this.tableViewer = new TableViewer(parent, 770);
        this.createColumns(this.tableViewer);
        this.setTableProvider(substances);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void update(IProcessingInfo processingInfo) {
        this.tableViewer.setInput((Object)processingInfo);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void copyToClipboard() {
        StringBuilder builder = new StringBuilder();
        int size = this.titles.length;
        String[] stringArray = this.titles;
        int n = this.titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            builder.append(title);
            builder.append(DELIMITER);
            ++n2;
        }
        builder.append(OperatingSystemUtils.getLineDelimiter());
        Table table = this.tableViewer.getTable();
        int[] nArray = table.getSelectionIndices();
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int index = nArray[n4];
            TableItem selection = table.getItem(index);
            int columnIndex = 0;
            while (columnIndex < size) {
                builder.append(selection.getText(columnIndex));
                builder.append(DELIMITER);
                ++columnIndex;
            }
            builder.append(OperatingSystemUtils.getLineDelimiter());
            ++n4;
        }
        if (builder.length() == 0) {
            builder.append("Please select one or more entries in the list.");
            builder.append(OperatingSystemUtils.getLineDelimiter());
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{builder.toString()};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        this.clipboard.setContents(data, dataTypes);
    }

    private void setTableProvider(Map<Long, String> substances) {
        this.tableViewer.setContentProvider((IContentProvider)new ProcessingInfoContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ProcessingInfoLabelProvider());
        this.processingInfoTableComparator = new ProcessingInfoTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.processingInfoTableComparator);
    }

    private void createColumns(final TableViewer tableViewer) {
        int i = 0;
        while (i < this.titles.length) {
            final int index = i;
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            final TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(this.titles[i]);
            tableColumn.setWidth(this.bounds[i]);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProcessingInfoUI.this.processingInfoTableComparator.setColumn(index);
                    int direction = tableViewer.getTable().getSortDirection();
                    direction = tableViewer.getTable().getSortColumn() == tableColumn ? (direction == 128 ? 1024 : 128) : 128;
                    tableViewer.getTable().setSortDirection(direction);
                    tableViewer.getTable().setSortColumn(tableColumn);
                    tableViewer.refresh();
                }
            });
            ++i;
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }
}

