/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;

abstract class RungeKuttaStepInterpolator
extends AbstractStepInterpolator {
    protected double[] previousState;
    protected double[][] yDotK;
    protected AbstractIntegrator integrator;

    protected RungeKuttaStepInterpolator() {
        this.previousState = null;
        this.yDotK = null;
        this.integrator = null;
    }

    public RungeKuttaStepInterpolator(RungeKuttaStepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.currentState != null) {
            this.previousState = (double[])interpolator.previousState.clone();
            this.yDotK = new double[interpolator.yDotK.length][];
            int k = 0;
            while (k < interpolator.yDotK.length) {
                this.yDotK[k] = (double[])interpolator.yDotK[k].clone();
                ++k;
            }
        } else {
            this.previousState = null;
            this.yDotK = null;
        }
        this.integrator = null;
    }

    public void reinitialize(AbstractIntegrator rkIntegrator, double[] y, double[][] yDotArray, boolean forward, EquationsMapper primaryMapper, EquationsMapper[] secondaryMappers) {
        this.reinitialize(y, forward, primaryMapper, secondaryMappers);
        this.previousState = null;
        this.yDotK = yDotArray;
        this.integrator = rkIntegrator;
    }

    @Override
    public void shift() {
        this.previousState = (double[])this.currentState.clone();
        super.shift();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeBaseExternal(out);
        int n = this.currentState == null ? -1 : this.currentState.length;
        int i = 0;
        while (i < n) {
            out.writeDouble(this.previousState[i]);
            ++i;
        }
        int kMax = this.yDotK == null ? -1 : this.yDotK.length;
        out.writeInt(kMax);
        int k = 0;
        while (k < kMax) {
            int i2 = 0;
            while (i2 < n) {
                out.writeDouble(this.yDotK[k][i2]);
                ++i2;
            }
            ++k;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int n;
        double t = this.readBaseExternal(in);
        int n2 = n = this.currentState == null ? -1 : this.currentState.length;
        if (n < 0) {
            this.previousState = null;
        } else {
            this.previousState = new double[n];
            int i = 0;
            while (i < n) {
                this.previousState[i] = in.readDouble();
                ++i;
            }
        }
        int kMax = in.readInt();
        this.yDotK = kMax < 0 ? null : new double[kMax][];
        int k = 0;
        while (k < kMax) {
            this.yDotK[k] = n < 0 ? null : new double[n];
            int i = 0;
            while (i < n) {
                this.yDotK[k][i] = in.readDouble();
                ++i;
            }
            ++k;
        }
        this.integrator = null;
        if (this.currentState != null) {
            this.setInterpolatedTime(t);
        } else {
            this.interpolatedTime = t;
        }
    }
}

