/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import java.util.Arrays;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.OptimumImpl;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.Precision;

public class LevenbergMarquardtOptimizer
implements LeastSquaresOptimizer {
    private static final double TWO_EPS = 2.0 * Precision.EPSILON;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double initialStepBoundFactor, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, double qrRankingThreshold) {
        this.initialStepBoundFactor = initialStepBoundFactor;
        this.costRelativeTolerance = costRelativeTolerance;
        this.parRelativeTolerance = parRelativeTolerance;
        this.orthoTolerance = orthoTolerance;
        this.qrRankingThreshold = qrRankingThreshold;
    }

    public LevenbergMarquardtOptimizer withInitialStepBoundFactor(double newInitialStepBoundFactor) {
        return new LevenbergMarquardtOptimizer(newInitialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withCostRelativeTolerance(double newCostRelativeTolerance) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, newCostRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withParameterRelativeTolerance(double newParRelativeTolerance) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, newParRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withOrthoTolerance(double newOrthoTolerance) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, newOrthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withRankingThreshold(double newQRRankingThreshold) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, newQRRankingThreshold);
    }

    public double getInitialStepBoundFactor() {
        return this.initialStepBoundFactor;
    }

    public double getCostRelativeTolerance() {
        return this.costRelativeTolerance;
    }

    public double getParameterRelativeTolerance() {
        return this.parRelativeTolerance;
    }

    public double getOrthoTolerance() {
        return this.orthoTolerance;
    }

    public double getRankingThreshold() {
        return this.qrRankingThreshold;
    }

    @Override
    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem problem) {
        int nR = problem.getObservationSize();
        int nC = problem.getParameterSize();
        Incrementor iterationCounter = problem.getIterationCounter();
        Incrementor evaluationCounter = problem.getEvaluationCounter();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> checker = problem.getConvergenceChecker();
        int solvedCols = FastMath.min(nR, nC);
        double[] lmDir = new double[nC];
        double lmPar = 0.0;
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[nC];
        double[] oldX = new double[nC];
        double[] oldRes = new double[nR];
        double[] qtf = new double[nR];
        double[] work1 = new double[nC];
        double[] work2 = new double[nC];
        double[] work3 = new double[nC];
        evaluationCounter.incrementCount();
        LeastSquaresProblem.Evaluation current = problem.evaluate(problem.getStart());
        double[] currentResiduals = current.getResiduals().toArray();
        double currentCost = current.getCost();
        double[] currentPoint = current.getPoint().toArray();
        boolean firstIteration = true;
        block0: while (true) {
            int j;
            iterationCounter.incrementCount();
            LeastSquaresProblem.Evaluation previous = current;
            InternalData internalData = this.qrDecomposition(current.getJacobian(), solvedCols);
            double[][] weightedJacobian = internalData.weightedJacobian;
            int[] permutation = internalData.permutation;
            double[] diagR = internalData.diagR;
            double[] jacNorm = internalData.jacNorm;
            double[] weightedResidual = currentResiduals;
            int i = 0;
            while (i < nR) {
                qtf[i] = weightedResidual[i];
                ++i;
            }
            this.qTy(qtf, internalData);
            int k = 0;
            while (k < solvedCols) {
                int pk = permutation[k];
                weightedJacobian[k][pk] = diagR[pk];
                ++k;
            }
            if (firstIteration) {
                xNorm = 0.0;
                k = 0;
                while (k < nC) {
                    double dk = jacNorm[k];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * currentPoint[k];
                    xNorm += xk * xk;
                    diag[k] = dk;
                    ++k;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (currentCost != 0.0) {
                j = 0;
                while (j < solvedCols) {
                    int pj = permutation[j];
                    double s = jacNorm[pj];
                    if (s != 0.0) {
                        double sum = 0.0;
                        int i2 = 0;
                        while (i2 <= j) {
                            sum += weightedJacobian[i2][pj] * qtf[i2];
                            ++i2;
                        }
                        maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s * currentCost));
                    }
                    ++j;
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                return new OptimumImpl(current, evaluationCounter.getCount(), iterationCounter.getCount());
            }
            j = 0;
            while (j < nC) {
                diag[j] = FastMath.max(diag[j], jacNorm[j]);
                ++j;
            }
            double ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) continue block0;
                int j2 = 0;
                while (j2 < solvedCols) {
                    int pj = permutation[j2];
                    oldX[pj] = currentPoint[pj];
                    ++j2;
                }
                double previousCost = currentCost;
                double[] tmpVec = weightedResidual;
                weightedResidual = oldRes;
                oldRes = tmpVec;
                lmPar = this.determineLMParameter(qtf, delta, diag, internalData, solvedCols, work1, work2, work3, lmDir, lmPar);
                double lmNorm = 0.0;
                int j3 = 0;
                while (j3 < solvedCols) {
                    int pj = permutation[j3];
                    lmDir[pj] = -lmDir[pj];
                    currentPoint[pj] = oldX[pj] + lmDir[pj];
                    double s = diag[pj] * lmDir[pj];
                    lmNorm += s * s;
                    ++j3;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                evaluationCounter.incrementCount();
                current = problem.evaluate(new ArrayRealVector(currentPoint));
                currentResiduals = current.getResiduals().toArray();
                currentCost = current.getCost();
                currentPoint = current.getPoint().toArray();
                double actRed = -1.0;
                if (0.1 * currentCost < previousCost) {
                    double r = currentCost / previousCost;
                    actRed = 1.0 - r * r;
                }
                int j4 = 0;
                while (j4 < solvedCols) {
                    int pj = permutation[j4];
                    double dirJ = lmDir[pj];
                    work1[j4] = 0.0;
                    int i3 = 0;
                    while (i3 <= j4) {
                        int n = i3;
                        work1[n] = work1[n] + weightedJacobian[i3][pj] * dirJ;
                        ++i3;
                    }
                    ++j4;
                }
                double coeff1 = 0.0;
                int j5 = 0;
                while (j5 < solvedCols) {
                    coeff1 += work1[j5] * work1[j5];
                    ++j5;
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d2 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * currentCost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    lmPar /= tmp;
                } else if (lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    int k2 = 0;
                    while (k2 < nC) {
                        double xK = diag[k2] * currentPoint[k2];
                        xNorm += xK * xK;
                        ++k2;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                    if (checker != null && checker.converged(iterationCounter.getCount(), previous, current)) {
                        return new OptimumImpl(current, evaluationCounter.getCount(), iterationCounter.getCount());
                    }
                } else {
                    currentCost = previousCost;
                    int j6 = 0;
                    while (j6 < solvedCols) {
                        int pj = permutation[j6];
                        currentPoint[pj] = oldX[pj];
                        ++j6;
                    }
                    tmpVec = weightedResidual;
                    weightedResidual = oldRes;
                    oldRes = tmpVec;
                    current = previous;
                }
                if (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm) {
                    return new OptimumImpl(current, evaluationCounter.getCount(), iterationCounter.getCount());
                }
                if (FastMath.abs(actRed) <= TWO_EPS && preRed <= TWO_EPS && ratio <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(delta <= TWO_EPS * xNorm)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(maxCosine <= TWO_EPS));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private double determineLMParameter(double[] qy, double delta, double[] diag, InternalData internalData, int solvedCols, double[] work1, double[] work2, double[] work3, double[] lmDir, double lmPar) {
        double sum;
        int pj;
        int j;
        double[][] weightedJacobian = internalData.weightedJacobian;
        int[] permutation = internalData.permutation;
        int rank = internalData.rank;
        double[] diagR = internalData.diagR;
        int nC = weightedJacobian[0].length;
        int j2 = 0;
        while (j2 < rank) {
            lmDir[permutation[j2]] = qy[j2];
            ++j2;
        }
        j2 = rank;
        while (j2 < nC) {
            lmDir[permutation[j2]] = 0.0;
            ++j2;
        }
        int k = rank - 1;
        while (k >= 0) {
            int pk = permutation[k];
            double ypk = lmDir[pk] / diagR[pk];
            int i = 0;
            while (i < k) {
                int n = permutation[i];
                lmDir[n] = lmDir[n] - ypk * weightedJacobian[i][pk];
                ++i;
            }
            lmDir[pk] = ypk;
            --k;
        }
        double dxNorm = 0.0;
        int j3 = 0;
        while (j3 < solvedCols) {
            double s;
            int pj2 = permutation[j3];
            work1[pj2] = s = diag[pj2] * lmDir[pj2];
            dxNorm += s * s;
            ++j3;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            lmPar = 0.0;
            return lmPar;
        }
        double parl = 0.0;
        if (rank == solvedCols) {
            j = 0;
            while (j < solvedCols) {
                int n = pj = permutation[j];
                work1[n] = work1[n] * (diag[pj] / dxNorm);
                ++j;
            }
            double sum2 = 0.0;
            j = 0;
            while (j < solvedCols) {
                double s;
                pj = permutation[j];
                sum = 0.0;
                int i = 0;
                while (i < j) {
                    sum += weightedJacobian[i][pj] * work1[permutation[i]];
                    ++i;
                }
                work1[pj] = s = (work1[pj] - sum) / diagR[pj];
                sum2 += s * s;
                ++j;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        j = 0;
        while (j < solvedCols) {
            pj = permutation[j];
            sum = 0.0;
            int i = 0;
            while (i <= j) {
                sum += weightedJacobian[i][pj] * qy[i];
                ++i;
            }
            sum2 += (sum /= diag[pj]) * sum;
            ++j;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = Precision.SAFE_MIN / FastMath.min(delta, 0.1);
        }
        if ((lmPar = FastMath.min(paru, FastMath.max(lmPar, parl))) == 0.0) {
            lmPar = gNorm / dxNorm;
        }
        int countdown = 10;
        while (countdown >= 0) {
            int pj3;
            int pj4;
            if (lmPar == 0.0) {
                lmPar = FastMath.max(Precision.SAFE_MIN, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(lmPar);
            int j4 = 0;
            while (j4 < solvedCols) {
                pj4 = permutation[j4];
                work1[pj4] = sPar * diag[pj4];
                ++j4;
            }
            this.determineLMDirection(qy, work1, work2, internalData, solvedCols, work3, lmDir);
            dxNorm = 0.0;
            j4 = 0;
            while (j4 < solvedCols) {
                double s;
                pj4 = permutation[j4];
                work3[pj4] = s = diag[pj4] * lmDir[pj4];
                dxNorm += s * s;
                ++j4;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return lmPar;
            }
            int j5 = 0;
            while (j5 < solvedCols) {
                pj3 = permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
                ++j5;
            }
            j5 = 0;
            while (j5 < solvedCols) {
                int n = pj3 = permutation[j5];
                work1[n] = work1[n] / work2[j5];
                double tmp = work1[pj3];
                int i = j5 + 1;
                while (i < solvedCols) {
                    int n2 = permutation[i];
                    work1[n2] = work1[n2] - weightedJacobian[i][pj3] * tmp;
                    ++i;
                }
                ++j5;
            }
            sum2 = 0.0;
            j5 = 0;
            while (j5 < solvedCols) {
                double s = work1[permutation[j5]];
                sum2 += s * s;
                ++j5;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, lmPar);
            }
            lmPar = FastMath.max(parl, lmPar + correction);
            --countdown;
        }
        return lmPar;
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, InternalData internalData, int solvedCols, double[] work, double[] lmDir) {
        int pj;
        int[] permutation = internalData.permutation;
        double[][] weightedJacobian = internalData.weightedJacobian;
        double[] diagR = internalData.diagR;
        int j = 0;
        while (j < solvedCols) {
            pj = permutation[j];
            int i = j + 1;
            while (i < solvedCols) {
                weightedJacobian[i][pj] = weightedJacobian[j][permutation[i]];
                ++i;
            }
            lmDir[j] = diagR[pj];
            work[j] = qy[j];
            ++j;
        }
        j = 0;
        while (j < solvedCols) {
            pj = permutation[j];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j + 1, lmDiag.length, 0.0);
            }
            lmDiag[j] = dpj;
            double qtbpj = 0.0;
            int k = j;
            while (k < solvedCols) {
                int pk = permutation[k];
                if (lmDiag[k] != 0.0) {
                    double cos;
                    double sin;
                    double rkk = weightedJacobian[k][pk];
                    if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k])) {
                        double cotan = rkk / lmDiag[k];
                        sin = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                        cos = sin * cotan;
                    } else {
                        double tan = lmDiag[k] / rkk;
                        cos = 1.0 / FastMath.sqrt(1.0 + tan * tan);
                        sin = cos * tan;
                    }
                    weightedJacobian[k][pk] = cos * rkk + sin * lmDiag[k];
                    double temp = cos * work[k] + sin * qtbpj;
                    qtbpj = -sin * work[k] + cos * qtbpj;
                    work[k] = temp;
                    int i = k + 1;
                    while (i < solvedCols) {
                        double rik = weightedJacobian[i][pk];
                        double temp2 = cos * rik + sin * lmDiag[i];
                        lmDiag[i] = -sin * rik + cos * lmDiag[i];
                        weightedJacobian[i][pk] = temp2;
                        ++i;
                    }
                }
                ++k;
            }
            lmDiag[j] = weightedJacobian[j][permutation[j]];
            weightedJacobian[j][permutation[j]] = lmDir[j];
            ++j;
        }
        int nSing = solvedCols;
        int j2 = 0;
        while (j2 < solvedCols) {
            if (lmDiag[j2] == 0.0 && nSing == solvedCols) {
                nSing = j2;
            }
            if (nSing < solvedCols) {
                work[j2] = 0.0;
            }
            ++j2;
        }
        if (nSing > 0) {
            j2 = nSing - 1;
            while (j2 >= 0) {
                int pj2 = permutation[j2];
                double sum = 0.0;
                int i = j2 + 1;
                while (i < nSing) {
                    sum += weightedJacobian[i][pj2] * work[i];
                    ++i;
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
                --j2;
            }
        }
        j2 = 0;
        while (j2 < lmDir.length) {
            lmDir[permutation[j2]] = work[j2];
            ++j2;
        }
    }

    private InternalData qrDecomposition(RealMatrix jacobian, int solvedCols) throws ConvergenceException {
        double[][] weightedJacobian = jacobian.scalarMultiply(-1.0).getData();
        int nR = weightedJacobian.length;
        int nC = weightedJacobian[0].length;
        int[] permutation = new int[nC];
        double[] diagR = new double[nC];
        double[] jacNorm = new double[nC];
        double[] beta = new double[nC];
        int k = 0;
        while (k < nC) {
            permutation[k] = k;
            double norm2 = 0.0;
            int i = 0;
            while (i < nR) {
                double akk = weightedJacobian[i][k];
                norm2 += akk * akk;
                ++i;
            }
            jacNorm[k] = FastMath.sqrt(norm2);
            ++k;
        }
        k = 0;
        while (k < nC) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            int i = k;
            while (i < nC) {
                double norm2 = 0.0;
                int j = k;
                while (j < nR) {
                    double aki = weightedJacobian[j][permutation[i]];
                    norm2 += aki * aki;
                    ++j;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, nR, nC);
                }
                if (norm2 > ak2) {
                    nextColumn = i;
                    ak2 = norm2;
                }
                ++i;
            }
            if (ak2 <= this.qrRankingThreshold) {
                return new InternalData(weightedJacobian, permutation, k, diagR, jacNorm, beta);
            }
            int pk = permutation[nextColumn];
            permutation[nextColumn] = permutation[k];
            permutation[k] = pk;
            double akk = weightedJacobian[k][pk];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            diagR[pk] = alpha;
            double[] dArray = weightedJacobian[k];
            int n = pk;
            dArray[n] = dArray[n] - alpha;
            int dk = nC - 1 - k;
            while (dk > 0) {
                double gamma = 0.0;
                int j = k;
                while (j < nR) {
                    gamma += weightedJacobian[j][pk] * weightedJacobian[j][permutation[k + dk]];
                    ++j;
                }
                gamma *= betak;
                j = k;
                while (j < nR) {
                    double[] dArray2 = weightedJacobian[j];
                    int n2 = permutation[k + dk];
                    dArray2[n2] = dArray2[n2] - gamma * weightedJacobian[j][pk];
                    ++j;
                }
                --dk;
            }
            ++k;
        }
        return new InternalData(weightedJacobian, permutation, solvedCols, diagR, jacNorm, beta);
    }

    private void qTy(double[] y, InternalData internalData) {
        double[][] weightedJacobian = internalData.weightedJacobian;
        int[] permutation = internalData.permutation;
        double[] beta = internalData.beta;
        int nR = weightedJacobian.length;
        int nC = weightedJacobian[0].length;
        int k = 0;
        while (k < nC) {
            int pk = permutation[k];
            double gamma = 0.0;
            int i = k;
            while (i < nR) {
                gamma += weightedJacobian[i][pk] * y[i];
                ++i;
            }
            gamma *= beta[pk];
            i = k;
            while (i < nR) {
                int n = i;
                y[n] = y[n] - gamma * weightedJacobian[i][pk];
                ++i;
            }
            ++k;
        }
    }

    private static class InternalData {
        private final double[][] weightedJacobian;
        private final int[] permutation;
        private final int rank;
        private final double[] diagR;
        private final double[] jacNorm;
        private final double[] beta;

        InternalData(double[][] weightedJacobian, int[] permutation, int rank, double[] diagR, double[] jacNorm, double[] beta) {
            this.weightedJacobian = weightedJacobian;
            this.permutation = permutation;
            this.rank = rank;
            this.diagR = diagR;
            this.jacNorm = jacNorm;
            this.beta = beta;
        }
    }
}

