/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.CacheIDFetcher;
import org.eclipse.birt.data.engine.executor.DataSourceFactory;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.FilterPrepareUtil;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.IQueryOptimizeHints;
import org.eclipse.birt.data.engine.impl.OdaDataSetRuntime;
import org.eclipse.birt.data.engine.impl.OdaDataSourceRuntime;
import org.eclipse.birt.data.engine.impl.OdaQueryOptimizationUtil;
import org.eclipse.birt.data.engine.impl.OptimizationRollbackHelper;
import org.eclipse.birt.data.engine.impl.ParameterMetaData;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.UserDefinedParamMetaData;
import org.eclipse.birt.data.engine.odaconsumer.QuerySpecHelper;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IParameterMetaData;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.ColumnIdentifier;
import org.mozilla.javascript.Scriptable;

public class PreparedOdaDSQuery
extends PreparedDataSourceQuery
implements IPreparedQuery {
    private ValidateStatus validateStatus;

    PreparedOdaDSQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext, IQueryContextVisitor visitor) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext != null ? appContext : new HashMap(), visitor);
        Object[] params = new Object[]{dataEngine, queryDefn, dataSetDesign, appContext};
        logger.exiting(PreparedOdaDSQuery.class.getName(), "PreparedOdaDSQuery", params);
        if (queryDefn.getQueryExecutionHints().enablePushDown()) {
            this.populateComputedColumnDataType(dataSetDesign);
        }
        this.validateStatus = ValidateStatus.unknown;
    }

    private void populateComputedColumnDataType(IBaseDataSetDesign dataSetDesign) {
        List computedColumns = dataSetDesign.getComputedColumns();
        List resultSets = dataSetDesign.getResultSetHints();
        int i = 0;
        while (i < computedColumns.size()) {
            IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
            String name = computedColumn.getName();
            int dataType = computedColumn.getDataType();
            int j = 0;
            while (j < resultSets.size()) {
                ColumnDefinition columnDef = (ColumnDefinition)resultSets.get(j);
                if (name.equals(columnDef.getColumnName())) {
                    columnDef.setDataType(dataType);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected QueryExecutor newExecutor() throws DataException {
        return new OdaDSQueryExecutor();
    }

    private static Map copyProperties(Map publicProps, Map privateProps) {
        if (publicProps.isEmpty() && privateProps.isEmpty()) {
            return null;
        }
        HashMap driverProps = new HashMap();
        if (!publicProps.isEmpty()) {
            driverProps.putAll(publicProps);
        }
        if (!privateProps.isEmpty()) {
            driverProps.putAll(privateProps);
        }
        return driverProps;
    }

    private static void addProperty(IDataSourceQuery odiDSQuery, Map props) throws DataException {
        if (props == null) {
            return;
        }
        Set entries = props.entrySet();
        for (Map.Entry entry : entries) {
            String propName = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (propName == null || propName.length() == 0) continue;
            odiDSQuery.addProperty(propName, value);
        }
    }

    @Override
    public Collection getParameterMetaData() throws DataException {
        OdaDSQueryExecutor exec = new OdaDSQueryExecutor();
        return exec.getParameterMetaData();
    }

    @Override
    public IQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        this.initializeExecution(outerResults, scope);
        return super.execute(outerResults, scope);
    }

    @Override
    protected void initializeExecution(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        this.configureParameterHints(this.queryDefn, this.appContext, scope);
    }

    private void configureParameterHints(IQueryDefinition querySpec, Map appContext, Scriptable scope) throws DataException {
        if (querySpec == null) {
            return;
        }
        if (querySpec.getQueryResultsID() != null) {
            return;
        }
        List paramList = this.dataSetDesign.getParameters();
        if (paramList == null || paramList.size() == 0) {
            return;
        }
        if (((IOdaDataSetDesign)this.dataSetDesign).getExtensionID().equals("org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet")) {
            appContext.put("org.eclipse.birt.report.data.oda.jdbc.ParameterHints", new UserDefinedParamMetaData(paramList));
        }
    }

    public class OdaDSQueryExecutor
    extends PreparedDataSourceQuery.DSQueryExecutor {
        private IPreparedDSQuery odiPreparedQuery;
        private QuerySpecification querySpec;

        public IPreparedDSQuery getPreparedOdiQuery() {
            return this.odiPreparedQuery;
        }

        @Override
        protected IDataSource createOdiDataSource() throws DataException {
            OdaDataSourceRuntime extDS = (OdaDataSourceRuntime)this.dataSource;
            assert (extDS != null);
            String driverName = extDS.getExtensionID();
            if (driverName == null || driverName.length() == 0) {
                throw new DataException("data.engine.DataSourceMissingExtId", extDS.getName());
            }
            ValidationContext validationContext = null;
            if (PreparedOdaDSQuery.this.queryDefn.getQueryExecutionHints().enablePushDown() && (validationContext = ((OdaDataSetRuntime)this.dataSet).getValidationContext()) != null) {
                Properties connProperties = new Properties();
                Map driverProps = PreparedOdaDSQuery.copyProperties(((OdaDataSourceRuntime)this.dataSource).getPublicProperties(), ((OdaDataSourceRuntime)this.dataSource).getPrivateProperties());
                if (driverProps != null) {
                    connProperties.putAll((Map<?, ?>)driverProps);
                }
                QuerySpecHelper.setValidationConnectionContext(validationContext, connProperties, PreparedOdaDSQuery.this.appContext);
            }
            Map driverProps = validationContext == null || validationContext.getConnection() == null ? PreparedOdaDSQuery.copyProperties(extDS.getPublicProperties(), extDS.getPrivateProperties()) : validationContext.getConnection().getProperties();
            return this.getDataSource(driverName, driverProps);
        }

        private IDataSource getDataSource(String driverName, Map driverProps) throws DataException {
            PreparedOdaDSQuery self = PreparedOdaDSQuery.this;
            return DataSourceFactory.getFactory().getDataSource(driverName, driverProps, self.dataEngine.getSession());
        }

        @Override
        protected IQuery createOdiQuery() throws DataException {
            ValidationContext validationContext;
            Map<String, QuerySpecification> optimizedDataSets;
            OdaDataSetRuntime extDataSet = (OdaDataSetRuntime)this.dataSet;
            assert (extDataSet != null);
            assert (this.odiDataSource != null);
            IDataSourceQuery odiQuery = null;
            String dataSetType = extDataSet.getExtensionID();
            String dataText = extDataSet.getQueryText();
            DataException exception = null;
            QuerySpecification combinedQuerySpec = null;
            IQueryOptimizeHints queryOptimizeHints = null;
            if (this.getAppContext() != null && (queryOptimizeHints = (IQueryOptimizeHints)this.getAppContext().get("org.eclipse.birt.data.internal.optimize.hints")) != null && (optimizedDataSets = queryOptimizeHints.getOptimizedCombinedQuerySpec()) != null) {
                for (Map.Entry<String, QuerySpecification> entry : optimizedDataSets.entrySet()) {
                    if (!entry.getKey().equals(extDataSet.getName())) continue;
                    combinedQuerySpec = entry.getValue();
                }
            }
            if (combinedQuerySpec != null) {
                this.querySpec = combinedQuerySpec;
                if (queryOptimizeHints != null) {
                    Map<String, List<Integer>> filtersMap;
                    List<IColumnDefinition> resultSets;
                    Map<String, List<String>> computedColumnsMap = queryOptimizeHints.getPushedDownComputedColumns();
                    if (computedColumnsMap != null && computedColumnsMap.get(extDataSet.getName()) != null) {
                        List computedColumns = extDataSet.getComputedColumns();
                        ArrayList toBeRemovedComputedColumns = new ArrayList();
                        int i = 0;
                        while (i < computedColumns.size()) {
                            if (computedColumnsMap.get(extDataSet.getName()).contains(((IComputedColumn)computedColumns.get(i)).getName())) {
                                toBeRemovedComputedColumns.add(computedColumns.get(i));
                            }
                            ++i;
                        }
                        computedColumns.removeAll(toBeRemovedComputedColumns);
                    }
                    if ((resultSets = queryOptimizeHints.getResultSetsForCombinedQuery()) != null && resultSets.size() > 0) {
                        extDataSet.getResultSetHints().clear();
                        extDataSet.getResultSetHints().addAll(resultSets);
                    }
                    if ((filtersMap = queryOptimizeHints.getPushedDownDataSetFilters()) != null && filtersMap.get(extDataSet.getName()) != null) {
                        List filters = extDataSet.getFilters();
                        ArrayList toBeRemovedFilters = new ArrayList();
                        int i = 0;
                        while (i < filters.size()) {
                            if (filtersMap.get(extDataSet.getName()).contains(i)) {
                                toBeRemovedFilters.add(filters.get(i));
                            }
                            ++i;
                        }
                        filters.removeAll(toBeRemovedFilters);
                    }
                    if (queryOptimizeHints.getUnpushedDownComputedColumnInCombinedQuery().size() > 0) {
                        extDataSet.getComputedColumns().addAll(queryOptimizeHints.getUnpushedDownComputedColumnInCombinedQuery());
                    }
                    if (queryOptimizeHints.getFilterNeededMerge().size() > 0) {
                        extDataSet.getFilters().addAll(queryOptimizeHints.getFilterNeededMerge());
                    }
                }
            } else if (PreparedOdaDSQuery.this.queryDefn.getQueryExecutionHints().enablePushDown() && (validationContext = ((OdaDataSetRuntime)this.dataSet).getValidationContext()) != null) {
                OptimizationRollbackHelper rollbackHelper;
                block31: {
                    validationContext.setQueryText(((IOdaDataSetDesign)PreparedOdaDSQuery.this.dataSetDesign).getQueryText());
                    validationContext.setData("org.eclipse.birt.data.applicationContext", (Object)this.getAppContext());
                    rollbackHelper = new OptimizationRollbackHelper(PreparedOdaDSQuery.this.queryDefn, (IOdaDataSetDesign)PreparedOdaDSQuery.this.dataSetDesign);
                    rollbackHelper.collectOriginalInfo();
                    try {
                        if (PreparedOdaDSQuery.this.validateStatus == ValidateStatus.unknown || PreparedOdaDSQuery.this.validateStatus == ValidateStatus.ok) {
                            this.querySpec = OdaQueryOptimizationUtil.optimizeExecution(((OdaDataSourceRuntime)PreparedOdaDSQuery.this.dataEngine.getDataSourceRuntime(PreparedOdaDSQuery.this.dataSetDesign.getDataSourceName())).getExtensionID(), validationContext, (IOdaDataSetDesign)PreparedOdaDSQuery.this.dataSetDesign, PreparedOdaDSQuery.this.queryDefn, PreparedOdaDSQuery.this.dataEngine.getSession(), PreparedOdaDSQuery.this.appContext, this.contextVisitor);
                        }
                        if (this.querySpec == null || PreparedOdaDSQuery.this.validateStatus != ValidateStatus.unknown) break block31;
                        try {
                            List<IColumnDefinition> trimmedColumns;
                            if (queryOptimizeHints != null && (trimmedColumns = queryOptimizeHints.getTrimmedColumns().get(extDataSet.getName())) != null) {
                                block8: for (IColumnDefinition col : trimmedColumns) {
                                    this.querySpec.getResultSetSpecification().getResultProjection().hideResultColumn(new ColumnIdentifier(col.getColumnName()));
                                    for (IColumnDefinition columnDefn : extDataSet.getResultSetHints()) {
                                        if (!columnDefn.getColumnName().equals(col.getColumnName())) continue;
                                        extDataSet.getResultSetHints().remove(columnDefn);
                                        continue block8;
                                    }
                                }
                                for (ColumnDefinition columnDefn : extDataSet.getResultSetHints()) {
                                    columnDefn.setColumnPosition(0);
                                }
                            }
                            this.querySpec.validate(validationContext);
                            PreparedOdaDSQuery.this.validateStatus = ValidateStatus.ok;
                        }
                        catch (OdaException ex) {
                            PreparedOdaDSQuery.this.validateStatus = ValidateStatus.fail;
                            this.querySpec = null;
                            logger.log(Level.WARNING, ex.getLocalizedMessage(), ex);
                        }
                        catch (Throwable e) {
                            logger.log(Level.WARNING, e.getLocalizedMessage(), e);
                            throw new DataException("data.filter.pushDownFail", e);
                        }
                    }
                    catch (DataException e) {
                        exception = e;
                    }
                }
                if (this.querySpec == null) {
                    rollbackHelper.rollback();
                }
            }
            if (FilterPrepareUtil.containsExternalFilter(PreparedOdaDSQuery.this.dataSetDesign.getFilters(), dataSetType, extDataSet.getDataSource().getExtensionID()) || FilterPrepareUtil.containsExternalFilter(PreparedOdaDSQuery.this.queryDefn.getFilters(), dataSetType, extDataSet.getDataSource().getExtensionID())) {
                if (exception != null) {
                    throw exception;
                }
                throw new DataException("data.filter.pushDownFail");
            }
            odiQuery = this.odiDataSource.newQuery(dataSetType, dataText, this.fromCache(), this.contextVisitor);
            if (odiQuery instanceof IPreparedDSQuery) {
                ((IPreparedDSQuery)((Object)odiQuery)).setQuerySpecification(this.querySpec);
            }
            return odiQuery;
        }

        @Override
        protected boolean fromCache() throws DataException {
            if (PreparedOdaDSQuery.this.queryDefn.getQueryExecutionHints().enablePushDown() && this.querySpec != null && this.querySpec.getResultSetSpecification() != null && !this.querySpec.getResultSetSpecification().isEmpty() && !CacheIDFetcher.getInstance().enableSampleDataPreivew(PreparedOdaDSQuery.this.appContext)) {
                PreparedOdaDSQuery.this.dataEngine.getSession().getDataSetCacheManager().clearCache(PreparedOdaDSQuery.this.dataEngine.getDataSourceDesign(this.dataSet.getDesign().getDataSourceName()), this.dataSet.getDesign());
            }
            return super.fromCache();
        }

        @Override
        protected void populateOdiQuery() throws DataException {
            List ccList;
            super.populateOdiQuery();
            OdaDataSetRuntime extDataSet = (OdaDataSetRuntime)this.dataSet;
            assert (extDataSet != null);
            IDataSourceQuery odiDSQuery = (IDataSourceQuery)this.odiQuery;
            assert (odiDSQuery != null);
            PreparedOdaDSQuery.addProperty(odiDSQuery, extDataSet.getPublicProperties());
            PreparedOdaDSQuery.addProperty(odiDSQuery, extDataSet.getPrivateProperties());
            odiDSQuery.setParameterHints(this.resolveDataSetParameters(true));
            if (extDataSet.getResultSetHints() != null) {
                List source = extDataSet.getResultSetHints();
                ArrayList<IDataSourceQuery.ResultFieldHint> odiHints = new ArrayList<IDataSourceQuery.ResultFieldHint>();
                int i = 0;
                while (i < source.size()) {
                    IColumnDefinition def = (IColumnDefinition)source.get(i);
                    if (!def.getColumnName().equals(def.getColumnNativeName()) || def.getAlias() != null) {
                        IDataSourceQuery.ResultFieldHint odiHint = new IDataSourceQuery.ResultFieldHint(def.getColumnName());
                        odiHint.setPosition(def.getColumnPosition());
                        odiHint.setAlias(def.getAlias());
                        odiHint.setDataType(def.getDataType());
                        odiHint.setNativeDataType(def.getNativeDataType());
                        odiHints.add(odiHint);
                    }
                    ++i;
                }
                odiDSQuery.setResultHints(odiHints);
            }
            if ((ccList = extDataSet.getComputedColumns()) != null) {
                int i = 0;
                while (i < ccList.size()) {
                    IComputedColumn cc = (IComputedColumn)ccList.get(i);
                    odiDSQuery.declareCustomField(cc.getName(), cc.getDataType());
                    ++i;
                }
            }
            odiDSQuery.setResultProjection(PreparedOdaDSQuery.this.getReportQueryDefn().getColumnProjection());
        }

        @Override
        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            this.dataSetAfterOpen();
            OdaDataSetRuntime odaDataSet = (OdaDataSetRuntime)this.dataSet;
            assert (odaDataSet != null);
            assert (this.odiPreparedQuery != null);
            return this.odiPreparedQuery.execute(eventHandler);
        }

        @Override
        protected void prepareOdiQuery() throws DataException {
            IDataSourceQuery odiDSQuery = (IDataSourceQuery)this.odiQuery;
            assert (odiDSQuery != null);
            assert (this.odiPreparedQuery == null);
            this.odiPreparedQuery = odiDSQuery.prepare();
            this.odiPreparedQuery.setQuerySpecification(this.querySpec);
        }

        private Collection getParameterMetaData() throws DataException {
            this.dataSet = this.newDataSetRuntime();
            assert (this.dataSet != null);
            OdaDataSetRuntime odaDataSet = (OdaDataSetRuntime)this.dataSet;
            this.dataSource = this.findDataSource();
            this.openDataSource();
            this.dataSet.beforeOpen();
            this.odiQuery = this.createOdiQuery();
            IDataSourceQuery odiDSQuery = (IDataSourceQuery)this.odiQuery;
            assert (odiDSQuery != null);
            PreparedOdaDSQuery.addProperty(odiDSQuery, odaDataSet.getPublicProperties());
            PreparedOdaDSQuery.addProperty(odiDSQuery, odaDataSet.getPrivateProperties());
            odiDSQuery.setParameterHints(this.resolveDataSetParameters(false));
            this.prepareOdiQuery();
            assert (this.odiPreparedQuery != null);
            Collection odiParamsInfo = this.odiPreparedQuery.getParameterMetaData();
            if (odiParamsInfo == null || odiParamsInfo.isEmpty()) {
                return null;
            }
            ArrayList<ParameterMetaData> paramMetaDataList = new ArrayList<ParameterMetaData>(odiParamsInfo.size());
            for (IParameterMetaData odiMetaData : odiParamsInfo) {
                ParameterMetaData apiMetaData = new ParameterMetaData(odiMetaData);
                paramMetaDataList.add(apiMetaData);
            }
            return paramMetaDataList;
        }
    }

    private static enum ValidateStatus {
        ok,
        unknown,
        fail;

    }
}

