/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.equations;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.equations.QuadraticEquation;
import org.eclipse.chemclipse.numeric.exceptions.GaussJordanError;
import org.eclipse.chemclipse.numeric.exceptions.SolverException;
import org.eclipse.chemclipse.numeric.internal.gaussjordan.GaussJordan;

public class Equations {
    public static final Logger logger = Logger.getLogger(Equations.class);

    public static LinearEquation createLinearEquation(IPoint p1, IPoint p2) {
        double a = Equations.calculateSlope(p1, p2);
        double b = p1.getY() - a * p1.getX();
        return new LinearEquation(a, b);
    }

    public static double calculateSlope(IPoint p1, IPoint p2) {
        if (p1 == null || p2 == null) {
            return 0.0;
        }
        double divider = p2.getX() - p1.getX();
        double a = divider == 0.0 ? 0.0 : (p2.getY() - p1.getY()) / divider;
        return a;
    }

    public static LinearEquation createLinearEquation(IPoint[] points) {
        double[][] valuesA = new double[points.length][2];
        double[][] valuesB = new double[points.length][2];
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < points.length) {
            IPoint p = points[i];
            if (p == null) {
                x = 0.0;
                y = 0.0;
            } else {
                x = p.getX();
                y = p.getY();
            }
            valuesA[i][0] = x;
            valuesA[i][1] = 1.0;
            valuesB[i][0] = y;
            ++i;
        }
        GaussJordan gj = new GaussJordan();
        double[][] a = gj.AtA(valuesA);
        double[][] b = gj.AtB(valuesA, valuesB);
        try {
            double[] result = gj.solve(a, b);
            return new LinearEquation(result[0], result[1]);
        }
        catch (GaussJordanError e) {
            logger.warn((Object)e);
            return null;
        }
    }

    public static double calculateWidth(IPoint p1, IPoint p2) {
        double a = p2.getY() - p1.getY();
        double b = p2.getX() - p1.getX();
        double c = Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
        return c;
    }

    public static IPoint calculateIntersection(LinearEquation eq1, LinearEquation eq2) throws SolverException {
        if (eq1.equals(eq2)) {
            throw new SolverException("There could be no intersection found. The equations are congruent.");
        }
        double denominator = eq1.getA() - eq2.getA();
        double numerator = eq2.getB() - eq1.getB();
        if (denominator == 0.0) {
            throw new SolverException("There could be no intersection found. The equations are parallel.");
        }
        double x = numerator / denominator;
        double y = eq1.calculateY(x);
        return new Point(x, y);
    }

    public static QuadraticEquation createQuadraticEquation(IPoint[] points) {
        double[][] valuesA = new double[points.length][3];
        double[][] valuesB = new double[points.length][3];
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < points.length) {
            IPoint p = points[i];
            if (p == null) {
                x = 0.0;
                y = 0.0;
            } else {
                x = p.getX();
                y = p.getY();
            }
            valuesA[i][0] = Math.pow(x, 2.0);
            valuesA[i][1] = x;
            valuesA[i][2] = 1.0;
            valuesB[i][0] = y;
            ++i;
        }
        GaussJordan gj = new GaussJordan();
        double[][] a = gj.AtA(valuesA);
        double[][] b = gj.AtB(valuesA, valuesB);
        try {
            double[] result = gj.solve(a, b);
            return new QuadraticEquation(result[0], result[1], result[2]);
        }
        catch (GaussJordanError e) {
            logger.warn((Object)e);
            return null;
        }
    }
}

