/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.data.DenseMatrix64F;

public class QrHelperFunctions_D64 {
    public static double findMax(double[] u, int startU, int length) {
        double max = -1.0;
        int index = startU;
        int stopIndex = startU + length;
        while (index < stopIndex) {
            double val = u[index];
            double d = val = val < 0.0 ? -val : val;
            if (val > max) {
                max = val;
            }
            ++index;
        }
        return max;
    }

    public static void divideElements(int j, int numRows, double[] u, double u_0) {
        int i = j;
        while (i < numRows) {
            int n = i++;
            u[n] = u[n] / u_0;
        }
    }

    public static void divideElements(int j, int numRows, double[] u, int startU, double u_0) {
        int i = j;
        while (i < numRows) {
            int n = i + startU;
            u[n] = u[n] / u_0;
            ++i;
        }
    }

    public static void divideElements_Brow(int j, int numRows, double[] u, double[] b, int startB, double u_0) {
        int i = j;
        while (i < numRows) {
            int n = i + startB;
            double d = b[n] / u_0;
            b[n] = d;
            u[i] = d;
            ++i;
        }
    }

    public static void divideElements_Bcol(int j, int numRows, int numCols, double[] u, double[] b, int startB, double u_0) {
        int indexB = j * numCols + startB;
        int i = j;
        while (i < numRows) {
            int n = i++;
            double d = u[n] / u_0;
            u[n] = d;
            b[indexB] = d;
            indexB += numCols;
        }
    }

    public static double computeTauAndDivide(int j, int numRows, double[] u, int startU, double max) {
        double tau = 0.0;
        int i = j;
        while (i < numRows) {
            int n = startU + i;
            double d = u[n] / max;
            u[n] = d;
            double d2 = d;
            tau += d2 * d2;
            ++i;
        }
        tau = Math.sqrt(tau);
        if (u[startU + j] < 0.0) {
            tau = -tau;
        }
        return tau;
    }

    public static double computeTauAndDivide(int j, int numRows, double[] u, double max) {
        double tau = 0.0;
        int i = j;
        while (i < numRows) {
            int n = i++;
            double d = u[n] / max;
            u[n] = d;
            double d2 = d;
            tau += d2 * d2;
        }
        tau = Math.sqrt(tau);
        if (u[j] < 0.0) {
            tau = -tau;
        }
        return tau;
    }

    public static void rank1UpdateMultR(DenseMatrix64F A, double[] u, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i = colA0;
        while (i < A.numCols) {
            _temp[i] = u[w0] * A.data[w0 * A.numCols + i];
            ++i;
        }
        int k = w0 + 1;
        while (k < w1) {
            int indexA = k * A.numCols + colA0;
            double valU = u[k];
            int i2 = colA0;
            while (i2 < A.numCols) {
                int n = i2++;
                _temp[n] = _temp[n] + valU * A.data[indexA++];
            }
            ++k;
        }
        i = colA0;
        while (i < A.numCols) {
            int n = i++;
            _temp[n] = _temp[n] * gamma;
        }
        i = w0;
        while (i < w1) {
            double valU = u[i];
            int indexA = i * A.numCols + colA0;
            int j = colA0;
            while (j < A.numCols) {
                int n = indexA++;
                A.data[n] = A.data[n] - valU * _temp[j];
                ++j;
            }
            ++i;
        }
    }

    public static void rank1UpdateMultR(DenseMatrix64F A, double[] u, int offsetU, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i = colA0;
        while (i < A.numCols) {
            _temp[i] = u[w0 + offsetU] * A.data[w0 * A.numCols + i];
            ++i;
        }
        int k = w0 + 1;
        while (k < w1) {
            int indexA = k * A.numCols + colA0;
            double valU = u[k + offsetU];
            int i2 = colA0;
            while (i2 < A.numCols) {
                int n = i2++;
                _temp[n] = _temp[n] + valU * A.data[indexA++];
            }
            ++k;
        }
        i = colA0;
        while (i < A.numCols) {
            int n = i++;
            _temp[n] = _temp[n] * gamma;
        }
        i = w0;
        while (i < w1) {
            double valU = u[i + offsetU];
            int indexA = i * A.numCols + colA0;
            int j = colA0;
            while (j < A.numCols) {
                int n = indexA++;
                A.data[n] = A.data[n] - valU * _temp[j];
                ++j;
            }
            ++i;
        }
    }

    public static void rank1UpdateMultL(DenseMatrix64F A, double[] u, double gamma, int colA0, int w0, int w1) {
        int i = colA0;
        while (i < A.numRows) {
            int startIndex = i * A.numCols + w0;
            double sum = 0.0;
            int rowIndex = startIndex;
            int j = w0;
            while (j < w1) {
                sum += A.data[rowIndex++] * u[j];
                ++j;
            }
            sum = -gamma * sum;
            rowIndex = startIndex;
            j = w0;
            while (j < w1) {
                int n = rowIndex++;
                A.data[n] = A.data[n] + sum * u[j];
                ++j;
            }
            ++i;
        }
    }
}

