/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.wizards;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io.PeakIdentificationBatchJobWriter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakIdentificationBatchJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.ui.wizards.AbstractFileWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentificationBatchJobWizard
extends AbstractFileWizard {
    private static final Logger logger = Logger.getLogger(PeakIdentificationBatchJobWizard.class);

    public PeakIdentificationBatchJobWizard() {
        super("PeakIdentificationBatchJob", ".opi");
    }

    public void doFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Create Peak Identification Batch Job", -1);
        IFile file = super.prepareProject(monitor);
        PeakIdentificationBatchJob batchProcessJob = new PeakIdentificationBatchJob(file.getName());
        batchProcessJob.setOverrideReport(false);
        batchProcessJob.setReportFolder(file.getProject().getLocation().toString());
        try {
            PeakIdentificationBatchJobWriter batchProcessJobWriter = new PeakIdentificationBatchJobWriter();
            batchProcessJobWriter.writeBatchProcessJob(file.getLocation().toFile(), (IPeakIdentificationBatchJob)batchProcessJob, monitor);
        }
        catch (FileNotFoundException e1) {
            logger.warn((Object)e1);
        }
        catch (FileIsNotWriteableException e1) {
            logger.warn((Object)e1);
        }
        catch (IOException e1) {
            logger.warn((Object)e1);
        }
        catch (XMLStreamException e1) {
            logger.warn((Object)e1);
        }
        super.refreshWorkspace(monitor);
        super.runOpenEditor(file, monitor);
    }
}

