/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.identifier.supplier.manual.ui.internal.wizards;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IdentificationPage
extends WizardPage {
    private Text textIdentificationName;
    private Text textCasNumber;
    private Text textComments;
    private Text textFormula;
    private Text textMolWeight;
    private NumberFormat numberFormat;

    public IdentificationPage(String pageName) {
        super(pageName);
        this.setTitle("Manual Peak Identification");
        this.setDescription("Set an identification entry manually.");
        this.setErrorMessage("Please set an identification name.");
        this.numberFormat = ValueFormat.getNumberFormatEnglish();
    }

    protected String getIdentificationName() {
        return this.textIdentificationName.getText();
    }

    protected String getCasNumber() {
        return this.textCasNumber.getText();
    }

    protected String getComments() {
        return this.textComments.getText();
    }

    protected String getFormula() {
        return this.textFormula.getText();
    }

    protected double getMolWeight() {
        try {
            return this.numberFormat.parse(this.textMolWeight.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        Label label = new Label(composite, 0);
        label.setText("Name*:");
        this.textIdentificationName = new Text(composite, 2048);
        this.textIdentificationName.setLayoutData((Object)gridData);
        this.textIdentificationName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String name = IdentificationPage.this.textIdentificationName.getText();
                if (name == null || name.equals("")) {
                    IdentificationPage.this.setErrorMessage("Please set an identification name.");
                } else {
                    IdentificationPage.this.setErrorMessage(null);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("CAS:");
        this.textCasNumber = new Text(composite, 2048);
        this.textCasNumber.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Comments:");
        this.textComments = new Text(composite, 2048);
        this.textComments.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Formula:");
        this.textFormula = new Text(composite, 2048);
        this.textFormula.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Mol Weight:");
        this.textMolWeight = new Text(composite, 2048);
        this.textMolWeight.setLayoutData((Object)gridData);
        this.setControl((Control)composite);
    }
}

