/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.core;

import org.eclipse.chemclipse.chromatogram.filter.processing.ChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator.IMassChromatographicQualityResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator.MassChromatographicQualityCalculator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.exceptions.CodaCalculatorException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.settings.CodaSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.settings.ICodaSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.settings.ISupplierFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilterMSD {
    private static WindowSize MOVING_AVERAGE_WINDOW = WindowSize.SCANS_5;
    private ICodaSettings codaSettings = null;

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        ChromatogramFilterResult chromatogramFilterResult;
        ChromatogramFilterProcessingInfo processingInfo = new ChromatogramFilterProcessingInfo();
        processingInfo.addMessages(this.validate(chromatogramSelection, chromatogramFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        this.setFilterSettings(chromatogramFilterSettings);
        try {
            this.applyCodaFilter(chromatogramSelection);
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.OK, "The chromatogram selection has been successfully cleaned by the coda algorithm.");
        }
        catch (FilterException e) {
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage());
        }
        processingInfo.setChromatogramFilterResult((IChromatogramFilterResult)chromatogramFilterResult);
        return processingInfo;
    }

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        IChromatogramFilterSettings chromatogramFilterSettings = PreferenceSupplier.getChromatogramFilterSettings();
        return this.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
    }

    private void setFilterSettings(IChromatogramFilterSettings chromatogramFilterSettings) {
        if (chromatogramFilterSettings instanceof ISupplierFilterSettings) {
            ISupplierFilterSettings settings = (ISupplierFilterSettings)chromatogramFilterSettings;
            this.codaSettings = settings.getCodaSettings();
        } else {
            this.codaSettings = new CodaSettings();
        }
    }

    private void applyCodaFilter(IChromatogramSelectionMSD chromatogramSelection) throws FilterException {
        IMarkedIons excludedIons;
        try {
            IMassChromatographicQualityResult result = MassChromatographicQualityCalculator.calculate(chromatogramSelection, this.codaSettings.getCodaThreshold(), MOVING_AVERAGE_WINDOW);
            excludedIons = result.getExcludedIons();
        }
        catch (CodaCalculatorException codaCalculatorException) {
            throw new FilterException("A failure occured while calculating the coda mass chromatographic quality.");
        }
        if (excludedIons == null) {
            throw new FilterException("The calculated excluded ions instance is null.");
        }
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum supplierMassSpectrum = chromatogram.getSupplierScan(scan);
            supplierMassSpectrum.removeIons(excludedIons);
            ++scan;
        }
    }
}

