/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.runnables.LibraryServiceRunnable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractMassSpectrumLibraryView {
    private static final Logger logger = Logger.getLogger(AbstractMassSpectrumLibraryView.class);
    private IEventBroker eventBroker;
    private MPart part;
    private EPartService partService;
    private EventHandler eventHandler;

    public AbstractMassSpectrumLibraryView(MPart part, EPartService partService, IEventBroker eventBroker) {
        this.part = part;
        this.partService = partService;
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    public boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    public void update(IScanMSD unknownMassSpectrum, IScanMSD libraryMassSpectrum, boolean forceReload) {
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    IScanMSD unknownMassSpectrum = (IScanMSD)event.getProperty("MassSpectrumUnknown");
                    IIdentificationTarget identificationTarget = (IIdentificationTarget)event.getProperty("IdentificationTarget");
                    AbstractMassSpectrumLibraryView.this.update(unknownMassSpectrum, identificationTarget);
                }
            };
            this.eventBroker.subscribe("identification/target/update/massspectrum/unknown", this.eventHandler);
        }
    }

    private void update(IScanMSD unknownMassSpectrum, IIdentificationTarget identificationTarget) {
        if (this.isPartVisible()) {
            LibraryServiceRunnable runnable = new LibraryServiceRunnable(this, unknownMassSpectrum, identificationTarget);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
        }
    }
}

