/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.client.v2.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.applications.LogsRequest;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.ProxyConfiguration;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.doppler.ReactorDopplerClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.cloudfoundry.reactor.uaa.ReactorUaaClient;
import org.cloudfoundry.uaa.UaaClient;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.client.CFClient;
import org.eclipse.cft.server.core.internal.client.CFCloudCredentials;
import org.eclipse.cft.server.core.internal.log.AppLogUtil;
import org.eclipse.cft.server.core.internal.log.CFApplicationLogListener;
import org.eclipse.cft.server.core.internal.log.CFStreamingLogToken;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import reactor.core.Cancellation;
import reactor.core.publisher.Flux;

public class V2Client
implements CFClient {
    public static final String HTTP_KEEP_ALIVE_SYSTEM_PROPERTY = "http.keepAlive";
    private CFCloudCredentials credentials;
    private CloudFoundryServer cloudServer;
    private String orgName;
    private String spaceName;
    private CloudFoundryClient v2Client = null;
    private CloudFoundryOperations v2Operations = null;

    public V2Client(CloudFoundryServer cloudServer, CFCloudCredentials credentials, String orgName, String spaceName) {
        Assert.isNotNull((Object)cloudServer);
        Assert.isNotNull((Object)credentials);
        Assert.isNotNull((Object)orgName);
        Assert.isNotNull((Object)spaceName);
        this.credentials = credentials;
        this.cloudServer = cloudServer;
        this.orgName = orgName;
        this.spaceName = spaceName;
    }

    public String login() throws CoreException {
        this.v2Client = null;
        this.v2Operations = null;
        this.getV2Operations();
        return null;
    }

    public CFStreamingLogToken streamLogs(String appName, CFApplicationLogListener listener) throws CoreException {
        return this.internalStreamLogs(appName, listener, false);
    }

    public List<CloudLog> getRecentLogs(String appName) throws CoreException {
        throw CloudErrorUtil.toCoreException((String)"Get recent logs not supported for v2 client.");
    }

    private CFStreamingLogToken internalStreamLogs(String appName, CFApplicationLogListener listener, boolean recentLogs) throws CoreException {
        CloudFoundryOperations operations = this.getV2Operations();
        V2LogListener v2Listener = this.asV2LogListener(listener);
        Flux stream = operations.applications().logs(LogsRequest.builder().name(appName).recent(Boolean.valueOf(recentLogs)).build());
        final Cancellation cancellation = stream.subscribe(v2Listener::onMessage, v2Listener::onError);
        return new CFStreamingLogToken(){

            public void cancel() {
                cancellation.dispose();
            }
        };
    }

    protected String getHost() {
        URI uri = URI.create(this.cloudServer.getUrl());
        return uri.getHost();
    }

    protected boolean skipSsl() {
        return this.cloudServer.isSelfSigned();
    }

    protected ProxyConfiguration getProxyConfiguration() {
        try {
            IProxyData proxyData = CloudServerUtil.getProxy((URL)new URL(this.cloudServer.getUrl()));
            if (proxyData != null) {
                String proxyHost = proxyData.getHost();
                int proxyPort = proxyData.getPort();
                String user = proxyData.getUserId();
                String password = proxyData.getPassword();
                return ProxyConfiguration.builder().host(proxyHost).port(proxyPort == -1 ? Optional.empty() : Optional.of(proxyPort)).username(Optional.ofNullable(user)).password(Optional.ofNullable(password)).build();
            }
        }
        catch (MalformedURLException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
        return null;
    }

    protected CloudFoundryOperations getV2Operations() throws CoreException {
        if (this.v2Operations == null) {
            try {
                boolean keepAlive = this.keepAlive();
                DefaultConnectionContext connection = DefaultConnectionContext.builder().proxyConfiguration(Optional.ofNullable(this.getProxyConfiguration())).apiHost(this.getHost()).sslHandshakeTimeout(Duration.ofSeconds(this.cloudServer.getSslHandshakeTimeout())).keepAlive(keepAlive).skipSslValidation(this.skipSsl()).build();
                PasswordGrantTokenProvider tokenProvider = PasswordGrantTokenProvider.builder().username(this.credentials.getUser()).password(this.credentials.getPassword()).build();
                ReactorUaaClient uaaClient = ReactorUaaClient.builder().connectionContext((ConnectionContext)connection).tokenProvider((TokenProvider)tokenProvider).build();
                ReactorDopplerClient dopplerClient = ReactorDopplerClient.builder().connectionContext((ConnectionContext)connection).tokenProvider((TokenProvider)tokenProvider).build();
                this.v2Client = ReactorCloudFoundryClient.builder().connectionContext((ConnectionContext)connection).tokenProvider((TokenProvider)tokenProvider).build();
                this.v2Operations = DefaultCloudFoundryOperations.builder().cloudFoundryClient(this.v2Client).dopplerClient((DopplerClient)dopplerClient).uaaClient((UaaClient)uaaClient).organization(this.orgName).space(this.spaceName).build();
            }
            catch (Throwable e) {
                throw CloudErrorUtil.toCoreException((Throwable)e);
            }
        }
        return this.v2Operations;
    }

    private boolean keepAlive() {
        return this.getBooleanSystemProp(HTTP_KEEP_ALIVE_SYSTEM_PROPERTY).isPresent();
    }

    private Optional<Boolean> getBooleanSystemProp(String name) {
        String str = System.getProperty(name);
        if (str != null) {
            return Optional.of(Boolean.valueOf(str));
        }
        return Optional.empty();
    }

    protected V2LogListener asV2LogListener(final CFApplicationLogListener listener) {
        return new V2LogListener(){

            @Override
            public void onMessage(LogMessage log) {
                CloudLog cloudLog = new CloudLog(log.getApplicationId(), AppLogUtil.format((String)log.getMessage()), new Date(log.getTimestamp()), LogContentType.APPLICATION_LOG_STD_OUT, log.getSourceInstance(), log.getSourceType());
                listener.onMessage(cloudLog);
            }

            @Override
            public void onError(Throwable exception) {
                listener.onError(exception);
            }

            @Override
            public void onComplete() {
                listener.onComplete();
            }
        };
    }

    public static interface V2LogListener {
        public void onMessage(LogMessage var1);

        public void onComplete();

        public void onError(Throwable var1);
    }
}

