/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServerRuntime;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ModuleCache;
import org.eclipse.cft.server.core.internal.ServerCredentialsStore;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.SelfSignedStore;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class CloudFoundryServer
extends ServerDelegate
implements IURLProvider {
    private static ThreadLocal<Boolean> deleteServicesOnModuleRemove = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private static final String OLD_PLUGIN_ID = "org.cloudfoundry.ide.eclipse.server.core";
    private static final String PROP_SERVER_ID = "org.eclipse.cft.serverId";
    private static final String OLD_PROP_SERVER_ID = "org.cloudfoundry.ide.eclipse.serverId";
    private static final String OLD_PROP_PASSWORD_ID = "org.cloudfoundry.ide.eclipse.password";
    private static final String PROP_URL = "org.eclipse.cft.url";
    private static final String OLD_PROP_URL = "org.cloudfoundry.ide.eclipse.url";
    private static final String PROP_USERNAME_ID = "org.eclipse.cft.username";
    private static final String OLD_PROP_USERNAME_ID = "org.cloudfoundry.ide.eclipse.username";
    private static final String PROP_ORG_ID = "org.eclipse.cft.org";
    private static final String OLD_PROP_ORG_ID = "org.cloudfoundry.ide.eclipse.org";
    private static final String PROP_SPACE_ID = "org.eclipse.cft.space";
    private static final String OLD_PROP_SPACE_ID = "org.cloudfoundry.ide.eclipse.space";
    static final String TUNNEL_SERVICE_COMMANDS_PROPERTY = "org.eclipse.cft.tunnel.service.commands";
    private static final String PROPERTY_DEPLOYMENT_NAME = "deployment_name";
    public static final String PROP_SSO_ID = "org.eclipse.cft.sso";
    public static final String PROP_PASSCODE_ID = "org.eclipse.cft.passcode";
    private static final long DEFAULT_SSL_HANDSHAKE_TIMEOUT = 60L;
    private String serverTypeId;
    private ServerCredentialsStore credentialsStore;
    private boolean secureStoreDirty;
    private String initialServerId;
    private String password;
    private CloudFoundrySpace cloudSpace;
    private String token;

    protected void updateState(Server server, CloudFoundryApplicationModule appModule) throws CoreException {
        IModule[] localModule = new IModule[]{appModule.getLocalModule()};
        server.setModuleState(localModule, appModule.getState());
        if (server.getModulePublishState(localModule) == 0) {
            if (!server.hasPublishedResourceDelta(localModule)) {
                server.setModulePublishState(localModule, 1);
            } else {
                server.setModulePublishState(localModule, 2);
            }
        }
        this.updateChildModuleStates(server, localModule);
    }

    private void updateChildModuleStates(Server server, IModule[] parentModule) throws CoreException {
        if (parentModule == null || parentModule.length == 0) {
            return;
        }
        int parentModuleSize = parentModule.length;
        IModule[] childModules = server.getChildModules(parentModule, null);
        if (childModules == null || childModules.length == 0) {
            return;
        }
        IModule[] iModuleArray = childModules;
        int n = childModules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule curChildModule = iModuleArray[n2];
            IModule[] curFullChildModule = new IModule[parentModuleSize + 1];
            System.arraycopy(parentModule, 0, curFullChildModule, 0, parentModuleSize);
            curFullChildModule[parentModuleSize] = curChildModule;
            if (server.getModulePublishState(curFullChildModule) == 0) {
                if (!server.hasPublishedResourceDelta(curFullChildModule)) {
                    server.setModulePublishState(curFullChildModule, 1);
                } else {
                    server.setModulePublishState(curFullChildModule, 2);
                }
            }
            this.updateChildModuleStates(server, curFullChildModule);
            ++n2;
        }
    }

    public void updateApplicationModule(CloudFoundryApplicationModule module) {
        if (this.getData() != null) {
            this.getData().updateCloudApplicationModule(module);
        }
    }

    public static boolean isNonfacetedModule(IModule module) {
        boolean isNonfacetedProjResult = false;
        ClassLoader classLoader = module.getClass().getClassLoader();
        if (classLoader != null) {
            try {
                Method getProperty;
                Object o;
                Class<?> iModule2 = classLoader.loadClass("org.eclipse.wst.server.core.IModule2");
                if (iModule2 != null && (o = (getProperty = iModule2.getMethod("getProperty", String.class)).invoke((Object)module, "org.eclipse.cft.server.core.property.PROPERTY_MODULE_NO_FACET")) instanceof String && ((String)o).equals("true")) {
                    isNonfacetedProjResult = true;
                }
            }
            catch (Exception exception) {}
        }
        return isNonfacetedProjResult;
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IStatus status;
                IModule module = add[i];
                if (!ApplicationRegistry.isSupportedModule(module)) {
                    return new Status(4, "org.eclipse.cft.server.core", 0, NLS.bind((String)Messages.CloudFoundryServer_ERROR_APPTYPE_NOT_SUPPORTED, (Object)module.getModuleType().getId()), null);
                }
                boolean ignoreFacetCheck = CloudFoundryServer.isNonfacetedModule(module);
                if (module.getProject() != null && !ignoreFacetCheck && (status = FacetUtil.verifyFacets((IProject)module.getProject(), (IServer)this.getServer())) != null && !status.isOK()) {
                    return status;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public void clearApplications() {
        ModuleCache.ServerData data = this.getData();
        if (data != null) {
            data.clear();
        }
    }

    public IStatus error(String message, Exception e) {
        return new Status(4, "org.eclipse.cft.server.core", NLS.bind((String)"{0} [{1}]", (Object)message, (Object)this.getServer().getName()), (Throwable)e);
    }

    public CloudFoundryApplicationModule getExistingCloudModule(IModule module) {
        IModule moduleToGet = module;
        if (module instanceof CloudFoundryApplicationModule) {
            moduleToGet = ((CloudFoundryApplicationModule)module).getLocalModule();
        }
        return this.getData() != null ? this.getData().getExistingCloudModule(moduleToGet) : null;
    }

    public CloudFoundryApplicationModule getOrCreateCloudModule(IModule module) {
        if (module == null) {
            return null;
        }
        IModule moduleToGet = module;
        if (module instanceof CloudFoundryApplicationModule) {
            moduleToGet = ((CloudFoundryApplicationModule)module).getLocalModule();
        }
        return this.getData() != null ? this.getData().getOrCreateCloudModule(moduleToGet) : null;
    }

    public IStatus refreshCloudModules() {
        if (this.getServerOriginal() == null) {
            return CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.CloudFoundryServer_ERROR_SERVER_ORIGIN_NOT_FOUND, (Object)this.getDeploymentName()));
        }
        IModule[] modules = this.getServerOriginal().getModules();
        if (modules != null) {
            StringWriter writer = new StringWriter();
            IModule[] iModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                CloudFoundryApplicationModule appModule = this.getOrCreateCloudModule(module);
                if (appModule == null) {
                    writer.append(Messages.CloudFoundryServer_ERROR_FAIL_ON_CFAPP_CREATION);
                    writer.append(module.getId());
                    writer.append('\n');
                }
                ++n2;
            }
            String message = writer.toString();
            if (message.length() > 0) {
                CloudFoundryPlugin.getErrorStatus(message);
            }
        }
        return Status.OK_STATUS;
    }

    public Collection<CloudFoundryApplicationModule> getExistingCloudModules() {
        return this.getData() != null ? this.getData().getExistingCloudModules() : new ArrayList(0);
    }

    public CloudFoundryServerBehaviour getBehaviour() {
        return (CloudFoundryServerBehaviour)((Object)this.getServer().loadAdapter(CloudFoundryServerBehaviour.class, null));
    }

    public IModule[] getChildModules(IModule[] module) {
        IWebModule webModule;
        if (module == null || module.length == 0) {
            return new IModule[0];
        }
        IModuleType moduleType = module[module.length - 1].getModuleType();
        if (moduleType != null && "jst.web".equals(moduleType.getId()) && (webModule = (IWebModule)module[module.length - 1].loadAdapter(IWebModule.class, null)) != null) {
            return webModule.getModules();
        }
        return new IModule[0];
    }

    private ModuleCache.ServerData getData() {
        return CloudFoundryPlugin.getModuleCache().getData(this.getServerOriginal());
    }

    public String getDeploymentName() {
        return this.getAttribute(PROPERTY_DEPLOYMENT_NAME, "");
    }

    public String getPassword() {
        String cachedPassword;
        if (this.secureStoreDirty) {
            return this.password;
        }
        String string = cachedPassword = this.getData() != null ? this.getData().getPassword() : null;
        if (cachedPassword != null) {
            return cachedPassword;
        }
        String legacyPassword = this.getAttribute(OLD_PROP_PASSWORD_ID, null);
        if (legacyPassword != null) {
            return legacyPassword;
        }
        return new ServerCredentialsStore(this.getServerId()).getPassword();
    }

    public String getToken() {
        String cachedToken;
        if (this.secureStoreDirty) {
            return this.token;
        }
        String string = cachedToken = this.getData() != null ? this.getData().getToken() : null;
        if (cachedToken != null) {
            return cachedToken;
        }
        return new ServerCredentialsStore(this.getServerId()).getToken();
    }

    public synchronized ServerCredentialsStore getCredentialsStore() {
        if (this.credentialsStore == null) {
            this.credentialsStore = this.isNewCFEclipseServer() ? new ServerCredentialsStore(this.initialServerId) : new ServerCredentialsStore(this.initialServerId, OLD_PLUGIN_ID);
        }
        return this.credentialsStore;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if (ApplicationRegistry.isSupportedModule(module)) {
            IStatus status = this.canModifyModules(new IModule[]{module}, null);
            if (status == null || !status.isOK()) {
                throw new CoreException(status);
            }
            return new IModule[]{module};
        }
        return J2EEUtil.getWebModules((IModule)module, null);
    }

    public CloudFoundryServerRuntime getRuntime() {
        return (CloudFoundryServerRuntime)((Object)this.getServer().getRuntime().loadAdapter(CloudFoundryServerRuntime.class, null));
    }

    public String getUrl() {
        if (this.isNewCFEclipseServer()) {
            return this.getAttribute(PROP_URL, null);
        }
        return this.getAttribute(OLD_PROP_URL, null);
    }

    public String getUsername() {
        if (this.isNewCFEclipseServer()) {
            return this.getAttribute(PROP_USERNAME_ID, null);
        }
        return this.getAttribute(OLD_PROP_USERNAME_ID, null);
    }

    public String getServerId() {
        if (this.isNewCFEclipseServer()) {
            return this.getAttribute(PROP_SERVER_ID, null);
        }
        return this.getAttribute(OLD_PROP_SERVER_ID, null);
    }

    public boolean isSso() {
        return this.getAttribute(PROP_SSO_ID, false);
    }

    public boolean hasCloudSpace() {
        return this.getCloudFoundrySpace() != null;
    }

    public CloudFoundrySpace getCloudFoundrySpace() {
        if (this.cloudSpace == null) {
            String orgName = this.getOrg();
            String spaceName = this.getSpace();
            String[] checkValidity = new String[]{orgName, spaceName};
            boolean valid = false;
            String[] stringArray = checkValidity;
            int n = checkValidity.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                valid = this.validSpaceValue(value);
                if (!valid) break;
                ++n2;
            }
            if (valid) {
                this.cloudSpace = new CloudFoundrySpace(orgName, spaceName);
            }
        }
        return this.cloudSpace;
    }

    protected boolean validSpaceValue(String value) {
        return value != null && value.length() > 0;
    }

    public boolean isConnected() {
        return this.getServer().getServerState() == 2;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        IModule module;
        int n;
        int n2;
        IModule[] iModuleArray;
        block11: {
            CloudFoundryApplicationModule toReplace;
            CloudFoundryPlugin.logInfo(CloudFoundryServer.convertModifyModulesToString(add, remove));
            CloudFoundryApplicationModule cloudFoundryApplicationModule = toReplace = remove != null && remove.length > 0 ? this.getExistingCloudModule(remove[0]) : null;
            if (toReplace != null && this.getData().getTaggedForReplace(toReplace) != null) {
                try {
                    this.replace(toReplace, add, monitor);
                }
                finally {
                    this.getData().untagForReplace(toReplace);
                }
            }
            if (remove != null && remove.length > 0) {
                if (this.getData() != null) {
                    iModuleArray = remove;
                    n2 = remove.length;
                    n = 0;
                    while (n < n2) {
                        module = iModuleArray[n];
                        this.getData().moduleAdditionCompleted(module);
                        ++n;
                    }
                }
                try {
                    this.getBehaviour().operations().deleteModules(remove, deleteServicesOnModuleRemove.get()).run(monitor);
                }
                catch (CoreException e) {
                    if (CloudErrorUtil.isNotFoundException(e)) break block11;
                    throw e;
                }
            }
        }
        if (add != null && add.length > 0 && this.getData() != null) {
            iModuleArray = add;
            n2 = add.length;
            n = 0;
            while (n < n2) {
                module = iModuleArray[n];
                this.getData().moduleBeingAdded(module);
                ++n;
            }
        }
    }

    protected void replace(CloudFoundryApplicationModule existingCloudModule, IModule[] targetModule, IProgressMonitor monitor) throws CoreException {
        final CloudFoundryApplicationModule existing = existingCloudModule;
        IModule[] target = targetModule;
        CloudApplication updatedCloudApplication = this.getBehaviour().getCloudApplication(existing.getDeployedApplicationName(), monitor);
        if (updatedCloudApplication == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.CloudFoundryServer_ERROR_UNABLE_REPLACE_MODULE_NO_CLOUD_APP, (Object)existing.getDeployedApplicationName()));
        }
        ApplicationStats stats = this.getBehaviour().getApplicationStats(existing.getDeployedApplicationName(), monitor);
        CloudFoundryPlugin.getCallback().stopApplicationConsole(existing, this);
        Server server = (Server)this.getServer();
        ArrayList<CloudFoundryApplicationModule> externalModules = new ArrayList<CloudFoundryApplicationModule>();
        IModule[] existingModule = new IModule[]{existing.getLocalModule()};
        int existingModuleState = server.getModuleState(existingModule);
        IModule[] iModuleArray = server.getModules();
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule appMLocalMod;
            IModule module = iModuleArray[n2];
            CloudFoundryApplicationModule appM = this.getExistingCloudModule(module);
            if (appM != null && appM.isExternal() && !(appMLocalMod = appM.getLocalModule()).getName().equals(existing.getLocalModule().getName())) {
                externalModules.add(appM);
            }
            ++n2;
        }
        server.setModulePublishState(existingModule, 0);
        server.setModuleState(existingModule, 0);
        this.getData().remove(existing);
        final ArrayList remainingModules = new ArrayList();
        server.visit(new IModuleVisitor(){

            public boolean visit(IModule[] module) {
                if (module.length > 0 && module[0].getName().equals(existing.getLocalModule().getName())) {
                    return false;
                }
                remainingModules.add(module);
                return true;
            }
        }, monitor);
        ServerPublishInfo info = server.getServerPublishInfo();
        info.removeDeletedModulePublishInfo(server, remainingModules);
        info.save();
        if (target != null && target.length > 0) {
            CloudFoundryApplicationModule remappedMod = this.getOrCreateCloudModule(target[0]);
            remappedMod.setCloudApplication(updatedCloudApplication);
            if (remappedMod.isExternal()) {
                externalModules.add(remappedMod);
            }
            server.setExternalModules(externalModules.toArray(new IModule[0]));
            this.updateState(server, remappedMod);
            server.setModulePublishState(new IModule[]{remappedMod.getLocalModule()}, 1);
            server.setModuleState(new IModule[]{remappedMod.getLocalModule()}, existingModuleState);
        } else {
            server.setExternalModules(externalModules.toArray(new IModule[0]));
            this.updateModule(updatedCloudApplication, existing.getDeployedApplicationName(), stats, monitor);
        }
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        String typeName = CloudFoundryBrandingExtensionPoint.getServerDisplayName(this.serverTypeId);
        if (typeName == null || typeName.trim().length() == 0) {
            typeName = this.getServer().getServerType().getName();
        }
        String name = typeName;
        int i = 2;
        while (ServerPlugin.isNameInUse((Object)this.getServerWorkingCopy().getOriginal(), (String)name)) {
            name = NLS.bind((String)"{0} ({1})", (Object[])new String[]{typeName, String.valueOf(i)});
            ++i;
        }
        this.getServerWorkingCopy().setName(name);
        this.getServerWorkingCopy().setHost("Cloud");
        this.setAttribute("auto-publish-setting", 1);
    }

    public void setDeploymentName(String name) {
        this.setAttribute(PROPERTY_DEPLOYMENT_NAME, name);
    }

    public void setPassword(String password) {
        this.secureStoreDirty = true;
        this.password = password;
        if (this.getServerWorkingCopy() != null) {
            this.getServerWorkingCopy().setAttribute(OLD_PROP_PASSWORD_ID, null);
        }
        this.updateServerId();
        if (this.getData() != null) {
            this.getData().setPassword(password);
        }
    }

    public void setSpace(CloudSpace space) {
        this.secureStoreDirty = true;
        if (space != null) {
            this.cloudSpace = new CloudFoundrySpace(space);
            this.internalSetOrg(this.cloudSpace.getOrgName());
            this.internalSetSpace(this.cloudSpace.getSpaceName());
        } else {
            this.internalSetOrg(null);
            this.internalSetSpace(null);
            this.cloudSpace = null;
        }
        this.updateServerId();
    }

    public void setUrl(String url) {
        if (this.isNewCFEclipseServer()) {
            this.setAttribute(PROP_URL, url);
        } else {
            this.setAttribute(OLD_PROP_URL, url);
        }
        this.updateServerId();
    }

    public void setUsername(String username) {
        if (this.isNewCFEclipseServer()) {
            this.setAttribute(PROP_USERNAME_ID, username);
        } else {
            this.setAttribute(OLD_PROP_USERNAME_ID, username);
        }
        this.updateServerId();
    }

    protected void internalSetOrg(String org) {
        if (this.isNewCFEclipseServer()) {
            this.setAttribute(PROP_ORG_ID, org);
        } else {
            this.setAttribute(OLD_PROP_ORG_ID, org);
        }
    }

    protected void internalSetSpace(String space) {
        if (this.isNewCFEclipseServer()) {
            this.setAttribute(PROP_SPACE_ID, space);
        } else {
            this.setAttribute(OLD_PROP_SPACE_ID, space);
        }
    }

    protected String getOrg() {
        if (this.isNewCFEclipseServer()) {
            return this.getAttribute(PROP_ORG_ID, null);
        }
        return this.getAttribute(OLD_PROP_ORG_ID, null);
    }

    protected String getSpace() {
        if (this.isNewCFEclipseServer()) {
            return this.getAttribute(PROP_SPACE_ID, null);
        }
        return this.getAttribute(OLD_PROP_SPACE_ID, null);
    }

    public boolean isSelfSigned() {
        return CloudFoundryServer.isSelfSigned(this.getUrl());
    }

    public void setSelfSigned(boolean isSelfSigned) {
        CloudFoundryServer.setSelfSigned(isSelfSigned, this.getUrl());
    }

    private void updateServerId() {
        StringWriter writer = new StringWriter();
        writer.append(this.getUsername());
        if (this.hasCloudSpace()) {
            writer.append('_');
            writer.append(this.getOrg());
            writer.append('_');
            writer.append(this.getSpace());
        }
        writer.append('@');
        writer.append(this.getUrl());
        if (this.isNewCFEclipseServer()) {
            this.setAttribute(PROP_SERVER_ID, writer.toString());
        } else {
            this.setAttribute(OLD_PROP_SERVER_ID, writer.toString());
        }
    }

    protected void initialize() {
        super.initialize();
        this.serverTypeId = this.getServer().getServerType().getId();
        this.password = this.getAttribute(OLD_PROP_PASSWORD_ID, null);
        this.initialServerId = this.getServerId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndDeleteModules(Map<String, CloudApplication> existingCloudApplications, Map<String, ApplicationStats> applicationStats, boolean updateCloudMappingInExistingModules) throws CoreException {
        Server server = (Server)this.getServer();
        HashSet<CloudFoundryApplicationModule> allModules = new HashSet<CloudFoundryApplicationModule>();
        ArrayList<CloudFoundryApplicationModule> externalModules = new ArrayList<CloudFoundryApplicationModule>();
        HashSet<IModule> deletedModules = new HashSet<IModule>();
        CloudFoundryServer cloudFoundryServer = this;
        synchronized (cloudFoundryServer) {
            IModule module2;
            IModule[] iModuleArray = server.getModules();
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                module2 = iModuleArray[n2];
                CloudFoundryApplicationModule cloudModule = this.getOrCreateCloudModule(module2);
                if (cloudModule == null) {
                    CloudFoundryPlugin.logError("Unable to find local Cloud Foundry application module for : " + module2.getName() + ". Try refreshing applications or disconnecting and reconnecting to the server.");
                } else {
                    CloudApplication actualApplication = existingCloudApplications.remove(cloudModule.getDeployedApplicationName());
                    if (updateCloudMappingInExistingModules) {
                        cloudModule.setCloudApplication(actualApplication);
                    }
                    if (actualApplication != null) {
                        if (cloudModule.isExternal()) {
                            externalModules.add(cloudModule);
                        }
                        allModules.add(cloudModule);
                    } else if (this.getData() != null && this.getData().isModuleBeingAdded(module2)) {
                        allModules.add(cloudModule);
                    } else {
                        deletedModules.add(module2);
                    }
                }
                ++n2;
            }
            if (this.getData() != null) {
                for (CloudApplication application : existingCloudApplications.values()) {
                    CloudFoundryApplicationModule appModule = this.getData().createModule(application);
                    externalModules.add(appModule);
                    allModules.add(appModule);
                }
            }
            server.setExternalModules(externalModules.toArray(new IModule[0]));
            iModuleArray = server.getModules();
            n = iModuleArray.length;
            int n3 = 0;
            while (n3 < n) {
                module2 = iModuleArray[n3];
                CloudFoundryApplicationModule appModule = this.getExistingCloudModule(module2);
                if (appModule != null) {
                    ApplicationStats stats = applicationStats.get(appModule.getDeployedApplicationName());
                    appModule.setApplicationStats(stats);
                }
                ++n3;
            }
            if (deletedModules.size() > 0) {
                for (IModule module2 : deletedModules) {
                    server.setModuleState(new IModule[]{module2}, 0);
                }
                this.doDeleteModules(deletedModules);
            }
            if (this.getData() != null) {
                this.getData().removeObsoleteModules(allModules);
            }
        }
    }

    public void updateModulesState() throws CoreException {
        this.updateModulesState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModulesState(int[] skipModulesInThisState) throws CoreException {
        CloudFoundryServer cloudFoundryServer = this;
        synchronized (cloudFoundryServer) {
            Server server = (Server)this.getServer();
            IModule[] iModuleArray = server.getModules();
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                CloudFoundryApplicationModule appModule = this.getExistingCloudModule(module);
                if (appModule != null) {
                    boolean update = true;
                    if (skipModulesInThisState != null) {
                        int currentModState = server.getModuleState(new IModule[]{module});
                        int[] nArray = skipModulesInThisState;
                        int n3 = skipModulesInThisState.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int state = nArray[n4];
                            if (currentModState == state) {
                                update = false;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (update) {
                        this.updateState(server, appModule);
                    }
                }
                ++n2;
            }
        }
    }

    public void updateModules(Map<String, CloudApplication> deployedApplications, Map<String, ApplicationStats> applicationStats) throws CoreException {
        boolean updateCloudMappingInExistingModules = true;
        this.addAndDeleteModules(deployedApplications, applicationStats, updateCloudMappingInExistingModules);
        this.updateModulesState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudFoundryApplicationModule updateModule(CloudApplication existingCloudApplication, String appName, ApplicationStats stats, IProgressMonitor monitor) throws CoreException {
        if (appName == null && existingCloudApplication != null) {
            appName = existingCloudApplication.getName();
        }
        if (existingCloudApplication == null && appName == null) {
            return null;
        }
        Server server = (Server)this.getServer();
        ArrayList<CloudFoundryApplicationModule> externalModules = new ArrayList<CloudFoundryApplicationModule>();
        CloudFoundryServer cloudFoundryServer = this;
        synchronized (cloudFoundryServer) {
            IModule module;
            IModule wstModule = null;
            CloudFoundryApplicationModule correspondingCloudModule = null;
            IModule[] iModuleArray = server.getModules();
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                module = iModuleArray[n2];
                CloudFoundryApplicationModule cloudModule = this.getExistingCloudModule(module);
                if (cloudModule != null) {
                    if (cloudModule.getDeployedApplicationName().equals(appName)) {
                        wstModule = module;
                        correspondingCloudModule = cloudModule;
                    } else if (cloudModule.isExternal()) {
                        externalModules.add(cloudModule);
                    }
                }
                ++n2;
            }
            if (this.getData() != null) {
                if (existingCloudApplication != null) {
                    if (correspondingCloudModule == null) {
                        correspondingCloudModule = this.getData().createModule(existingCloudApplication);
                        externalModules.add(correspondingCloudModule);
                    } else {
                        if (correspondingCloudModule.isExternal()) {
                            externalModules.add(correspondingCloudModule);
                        }
                        correspondingCloudModule.setCloudApplication(existingCloudApplication);
                    }
                    if (correspondingCloudModule != null) {
                        correspondingCloudModule.setApplicationStats(stats);
                    }
                } else if (!this.getData().isModuleBeingAdded(wstModule)) {
                    if (wstModule != null) {
                        server.setModuleState(new IModule[]{wstModule}, 0);
                        this.deleteModule(wstModule);
                    }
                    if (correspondingCloudModule != null) {
                        this.getData().remove(correspondingCloudModule);
                        correspondingCloudModule = null;
                    }
                }
            }
            server.setExternalModules(externalModules.toArray(new IModule[0]));
            iModuleArray = server.getModules();
            n = iModuleArray.length;
            n2 = 0;
            while (n2 < n) {
                module = iModuleArray[n2];
                CloudFoundryApplicationModule appModule = this.getExistingCloudModule(module);
                if (appModule != null) {
                    this.updateState(server, appModule);
                }
                ++n2;
            }
            return correspondingCloudModule;
        }
    }

    private void deleteModule(IModule module) {
        ArrayList<IModule> modsToDelete = new ArrayList<IModule>();
        modsToDelete.add(module);
        this.doDeleteModules(modsToDelete);
    }

    public void removeApplication(CloudFoundryApplicationModule cloudModule) {
        if (this.getData() != null) {
            this.getData().remove(cloudModule);
        }
    }

    public IServer getServerOriginal() {
        IServer server = this.getServer();
        if (server instanceof IServerWorkingCopy) {
            return ((IServerWorkingCopy)server).getOriginal();
        }
        return server;
    }

    String getServerAttribute(String key, String defaultValue) {
        return super.getAttribute(key, defaultValue);
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        String serverId = this.getServerId();
        if (this.secureStoreDirty || serverId != null && !serverId.equals(this.initialServerId)) {
            if (this.getData() != null) {
                this.getData().updateServerId(this.initialServerId, serverId);
                this.getData().setPassword(this.password);
            }
            ServerCredentialsStore store = this.getCredentialsStore();
            store.setUsername(this.getUsername());
            store.setPassword(this.password);
            store.flush(serverId);
            this.initialServerId = serverId;
            this.secureStoreDirty = false;
        }
        super.saveConfiguration(monitor);
    }

    public void setAndSavePassword(String password) {
        this.password = password;
        if (this.getServerWorkingCopy() != null) {
            this.getServerWorkingCopy().setAttribute(OLD_PROP_PASSWORD_ID, null);
        }
        if (this.getData() != null) {
            this.getData().setPassword(password);
        }
        String serverId = this.getServerId();
        ServerCredentialsStore store = this.getCredentialsStore();
        store.setUsername(this.getUsername());
        store.setPassword(password);
        store.flush(serverId);
    }

    public void setAndSaveToken(String token) {
        this.token = token;
        if (this.getData() != null) {
            this.getData().setToken(token);
        }
        String serverId = this.getServerId();
        ServerCredentialsStore store = this.getCredentialsStore();
        store.setToken(token);
        store.flush(serverId);
    }

    public IStatus doDeleteModules(Collection<IModule> deletedModules) {
        IServerWorkingCopy wc = this.getServer().createWorkingCopy();
        try {
            try {
                deleteServicesOnModuleRemove.set(Boolean.FALSE);
                wc.modifyModules(null, deletedModules.toArray(new IModule[deletedModules.size()]), null);
                wc.save(true, null);
                IServer server = this.getServer();
                if (server instanceof Server) {
                    final ArrayList modulesToVisit = new ArrayList();
                    final Server serv = (Server)server;
                    serv.visit(new IModuleVisitor(){

                        public boolean visit(IModule[] module) {
                            if (serv.getModulePublishState(module) == 1) {
                                serv.getServerPublishInfo().fill(module);
                            }
                            modulesToVisit.add(module);
                            return true;
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                    serv.getServerPublishInfo().removeDeletedModulePublishInfo(serv, modulesToVisit);
                    serv.getServerPublishInfo().save();
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.core", "Unexpected error while updating modules", (Throwable)e));
                IStatus iStatus = Status.CANCEL_STATUS;
                deleteServicesOnModuleRemove.set(Boolean.TRUE);
                return iStatus;
            }
        }
        finally {
            deleteServicesOnModuleRemove.set(Boolean.TRUE);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleAdditionCompleted(IModule module) {
        CloudFoundryServer cloudFoundryServer = this;
        synchronized (cloudFoundryServer) {
            if (this.getData() != null) {
                this.getData().moduleAdditionCompleted(module);
            }
        }
    }

    public CloudFoundryApplicationModule getExistingCloudModule(String appName) throws CoreException {
        if (appName == null) {
            return null;
        }
        CloudFoundryApplicationModule appModule = null;
        Collection<CloudFoundryApplicationModule> modules = this.getExistingCloudModules();
        if (modules != null) {
            for (CloudFoundryApplicationModule module : modules) {
                if (!appName.equals(module.getDeployedApplicationName())) continue;
                appModule = module;
                break;
            }
        }
        return appModule;
    }

    public static void setSelfSigned(boolean isSelfSigned, String cloudServerURL) {
        try {
            new SelfSignedStore(cloudServerURL).setSelfSignedCert(isSelfSigned);
        }
        catch (Throwable e) {
            CloudFoundryPlugin.logError(e);
        }
    }

    public static boolean isSelfSigned(String cloudServerURL) {
        try {
            return new SelfSignedStore(cloudServerURL).isSelfSignedCert();
        }
        catch (Throwable e) {
            CloudFoundryPlugin.logError(e);
            return false;
        }
    }

    public URL getModuleRootURL(IModule curModule) {
        List uris;
        CloudFoundryApplicationModule cloudModule = this.getOrCreateCloudModule(curModule);
        if (cloudModule == null) {
            return null;
        }
        List list = uris = cloudModule != null && cloudModule.getApplication() != null ? cloudModule.getApplication().getUris() : null;
        if (uris != null && !uris.isEmpty()) {
            try {
                return new URL("http://" + (String)uris.get(0));
            }
            catch (MalformedURLException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return null;
    }

    public IModule[][] getLaunchableModules(IModule root) {
        return new IModule[][]{{root}};
    }

    public String getLaunchableModuleContextRoot(IModule[] module) {
        return null;
    }

    private boolean isNewCFEclipseServer() {
        String oldPropServerIdVal = this.getAttribute(OLD_PROP_SERVER_ID, null);
        return oldPropServerIdVal == null;
    }

    public HttpProxyConfiguration getProxyConfiguration() {
        return null;
    }

    public String getPasscode() {
        return this.getAttribute(PROP_PASSCODE_ID, "");
    }

    public void setPasscode(String passcode) {
        this.setAttribute(PROP_PASSCODE_ID, passcode);
        this.updateServerId();
    }

    public void setSso(boolean selection) {
        this.setAttribute(PROP_SSO_ID, selection);
        this.updateServerId();
    }

    private static String moduleListToString(IModule[] module) {
        String moduleStr = "{ ";
        if (module != null) {
            int x = 0;
            while (x < module.length) {
                IModule currModule = module[x];
                if (currModule != null) {
                    moduleStr = String.valueOf(moduleStr) + currModule.getName() + " [" + currModule.getId() + "/" + (currModule.getModuleType() != null ? currModule.getModuleType().getId() : "") + "]";
                    if (x + 1 < module.length) {
                        moduleStr = String.valueOf(moduleStr) + ", ";
                    }
                }
                ++x;
            }
        }
        moduleStr = String.valueOf(moduleStr.trim()) + "}";
        return moduleStr;
    }

    private static String convertModifyModulesToString(IModule[] addModules, IModule[] removeModules) {
        try {
            return "CloudFoundryServer.modifyModules(...): add: " + CloudFoundryServer.moduleListToString(addModules) + " remove: " + CloudFoundryServer.moduleListToString(removeModules);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public long getSslHandshakeTimeout() {
        return 60L;
    }
}

