/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.OperationScheduler;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.BehaviourOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class UpdateOperationsScheduler
implements OperationScheduler {
    private BehaviourRefreshJob refreshJob;
    private final CloudFoundryServer cloudServer;
    private BehaviourOperation opToRun;

    public UpdateOperationsScheduler(CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        String serverName = cloudServer != null ? cloudServer.getServer().getId() : "Unknown server";
        String refreshJobLabel = NLS.bind((String)Messages.RefreshModulesHandler_REFRESH_JOB, (Object)serverName);
        this.refreshJob = new BehaviourRefreshJob(refreshJobLabel);
    }

    @Override
    public synchronized BehaviourOperation getCurrentOperation() {
        return this.opToRun;
    }

    public synchronized void updateAll() {
        this.scheduleRefresh(this.cloudServer.getBehaviour().operations().updateAll());
    }

    public synchronized void updateDeployedModule(IModule module) {
        this.scheduleRefresh(this.cloudServer.getBehaviour().operations().updateDeployedModule(module));
    }

    public synchronized void updateModule(IModule module) {
        this.scheduleRefresh(this.cloudServer.getBehaviour().operations().updateModule(module));
    }

    public synchronized void updateModuleAfterPublish(IModule module) {
        this.scheduleRefresh(this.cloudServer.getBehaviour().operations().updateOnPublish(module));
    }

    private synchronized void scheduleRefresh(BehaviourOperation opToRun) {
        if (this.opToRun == null) {
            this.opToRun = opToRun;
            this.schedule();
        }
    }

    private void schedule() {
        this.refreshJob.setSystem(false);
        this.refreshJob.schedule();
    }

    private class BehaviourRefreshJob
    extends Job {
        public BehaviourRefreshJob(String label) {
            super(label);
        }

        public IStatus run(IProgressMonitor monitor) {
            IModule module = null;
            try {
                CloudFoundryServer cloudServer = null;
                module = UpdateOperationsScheduler.this.opToRun.getModule();
                try {
                    cloudServer = UpdateOperationsScheduler.this.opToRun.getBehaviour() != null ? UpdateOperationsScheduler.this.opToRun.getBehaviour().getCloudFoundryServer() : null;
                }
                catch (CoreException ce) {
                    CloudFoundryPlugin.logError(ce);
                    IStatus iStatus = ce.getStatus();
                    UpdateOperationsScheduler.this.opToRun = null;
                    return iStatus;
                }
                if (cloudServer == null) {
                    IStatus error = CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.RefreshModulesHandler_EVENT_CLOUD_SERVER_NULL, UpdateOperationsScheduler.this.opToRun.getClass()));
                    CloudFoundryPlugin.log(error);
                    IStatus iStatus = error;
                    return iStatus;
                }
                this.runOperation(module, cloudServer, monitor);
            }
            finally {
                UpdateOperationsScheduler.this.opToRun = null;
            }
            return Status.OK_STATUS;
        }

        protected void runOperation(IModule module, CloudFoundryServer cloudServer, IProgressMonitor monitor) {
            block11: {
                IStatus errorStatus = null;
                try {
                    try {
                        ServerEventHandler.getDefault().fireUpdateStarting(cloudServer);
                        UpdateOperationsScheduler.this.opToRun.run(monitor);
                    }
                    catch (Throwable t) {
                        cloudServer.setAndSaveToken(null);
                        errorStatus = CloudFoundryPlugin.getErrorStatus(Messages.RefreshModulesHandler_REFRESH_FAILURE, t);
                        if (errorStatus != null) {
                            ServerEventHandler.getDefault().fireError(cloudServer, module, errorStatus);
                        } else {
                            ServerEventHandler.getDefault().fireUpdateCompleted(cloudServer);
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (errorStatus != null) {
                        ServerEventHandler.getDefault().fireError(cloudServer, module, errorStatus);
                    } else {
                        ServerEventHandler.getDefault().fireUpdateCompleted(cloudServer);
                    }
                    throw throwable;
                }
                if (errorStatus != null) {
                    ServerEventHandler.getDefault().fireError(cloudServer, module, errorStatus);
                } else {
                    ServerEventHandler.getDefault().fireUpdateCompleted(cloudServer);
                }
            }
        }
    }
}

