/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.ModuleCache;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;

public class UnmapProjectOperation
implements ICloudFoundryOperation {
    private final CloudFoundryApplicationModule appModule;
    private final CloudFoundryServer cloudServer;

    public UnmapProjectOperation(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        this.appModule = appModule;
        this.cloudServer = cloudServer;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        IServer server = this.cloudServer.getServer();
        IServerWorkingCopy wc = server.createWorkingCopy();
        ModuleCache moduleCache = CloudFoundryPlugin.getModuleCache();
        ModuleCache.ServerData data = moduleCache.getData(this.cloudServer.getServerOriginal());
        data.tagForReplace(this.appModule);
        ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[0], (IModule[])new IModule[]{this.appModule.getLocalModule()}, (IProgressMonitor)monitor);
        wc.save(true, monitor);
        CloudFoundryApplicationModule updatedModule = this.cloudServer.getExistingCloudModule(this.appModule.getDeployedApplicationName());
        if (updatedModule != null) {
            this.cloudServer.getBehaviour().operations().updateModule(updatedModule.getLocalModule()).run(monitor);
        }
        ServerEventHandler.getDefault().fireServerRefreshed(this.cloudServer);
    }
}

