/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.LinkedHashMap;
import java.util.List;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.AppsAndServicesRefreshEvent;
import org.eclipse.cft.server.core.internal.client.BehaviourOperation;
import org.eclipse.cft.server.core.internal.client.CFV1Application;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class UpdateAllOperation
extends BehaviourOperation {
    public UpdateAllOperation(CloudFoundryServerBehaviour behaviour) {
        super(behaviour, null);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(NLS.bind((String)Messages.CloudBehaviourOperations_REFRESHING_APPS_AND_SERVICES, (Object)cloudServer.getServer().getId()), 100);
        List<CFServiceInstance> services = this.getBehaviour().getServices((IProgressMonitor)subMonitor.newChild(20));
        List<CloudApplication> applications = this.updateBasicListOfApps(cloudServer, subMonitor.newChild(30));
        this.fireRefreshEvent(services);
        this.updateCompleteApps(applications, cloudServer, subMonitor.newChild(70));
        this.fireRefreshEvent(services);
        subMonitor.worked(20);
    }

    protected void fireRefreshEvent(List<CFServiceInstance> services) throws CoreException {
        ServerEventHandler.getDefault().fireServerEvent(new AppsAndServicesRefreshEvent(this.getBehaviour().getCloudFoundryServer(), this.getModule(), 400, services));
    }

    protected List<CloudApplication> updateBasicListOfApps(CloudFoundryServer cloudServer, SubMonitor subMonitor) throws CoreException {
        List<CloudApplication> applications = this.getBehaviour().getBasicApplications((IProgressMonitor)subMonitor);
        LinkedHashMap<String, CloudApplication> deployedApplicationsByName = new LinkedHashMap<String, CloudApplication>();
        LinkedHashMap<String, ApplicationStats> stats = new LinkedHashMap<String, ApplicationStats>();
        for (CloudApplication application : applications) {
            deployedApplicationsByName.put(application.getName(), application);
        }
        cloudServer.addAndDeleteModules(deployedApplicationsByName, stats);
        cloudServer.updateModulesState(new int[]{1});
        return applications;
    }

    protected void updateCompleteApps(List<CloudApplication> applications, CloudFoundryServer cloudServer, SubMonitor subMonitor) throws CoreException {
        LinkedHashMap<String, CloudApplication> deployedApplicationsByName = new LinkedHashMap<String, CloudApplication>();
        LinkedHashMap<String, ApplicationStats> stats = new LinkedHashMap<String, ApplicationStats>();
        for (CloudApplication toUpdate : applications) {
            CFV1Application updatedApplication = this.getBehaviour().getCompleteApplication(toUpdate, (IProgressMonitor)subMonitor);
            if (updatedApplication.getStats() != null) {
                stats.put(toUpdate.getName(), updatedApplication.getStats());
            }
            deployedApplicationsByName.put(toUpdate.getName(), updatedApplication.getApplication());
            subMonitor.worked(1);
        }
        cloudServer.addAndDeleteModules(deployedApplicationsByName, stats);
        cloudServer.updateModulesState(new int[]{1});
        IModule[] iModuleArray = cloudServer.getServer().getModules();
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
            if (appModule != null) {
                appModule.setStatus(null);
                appModule.validateDeploymentInfo();
            }
            ++n2;
        }
    }
}

