/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerSpacesDelegate;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryCloudSpaceWizardpage;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryCredentialsWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class CloudFoundryCredentialsWizard
extends Wizard {
    private final CloudFoundryServer server;
    private final IServerWorkingCopy serverWC;
    private CloudFoundryCloudSpaceWizardpage cloudSpacePage;
    private CloudFoundryCredentialsWizardPage credentialsPage;

    public CloudFoundryCredentialsWizard(CloudFoundryServer server) {
        this.serverWC = server.getServer().createWorkingCopy();
        this.server = (CloudFoundryServer)this.serverWC.loadAdapter(CloudFoundryServer.class, null);
        this.setWindowTitle(server.getServer().getName());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        this.credentialsPage = new CloudFoundryCredentialsWizardPage(this.server);
        this.addPage((IWizardPage)this.credentialsPage);
    }

    public boolean canFinish() {
        if (this.cloudSpacePage == null || !this.cloudSpacePage.isPageComplete()) {
            return false;
        }
        return super.canFinish() && this.credentialsPage != null && this.credentialsPage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        CloudServerSpacesDelegate cloudServerSpaceDelegate;
        if (page == this.credentialsPage && (cloudServerSpaceDelegate = this.credentialsPage.getServerSpaceDelegate()) != null && cloudServerSpaceDelegate.getCurrentSpacesDescriptor() != null) {
            this.cloudSpacePage = new CloudFoundryCloudSpaceWizardpage(this.server, cloudServerSpaceDelegate);
            this.cloudSpacePage.setWizard((IWizard)this);
            return this.cloudSpacePage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof CloudFoundryCloudSpaceWizardpage) {
            return this.credentialsPage;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        try {
            this.serverWC.save(true, null);
        }
        catch (CoreException e) {
            CloudFoundryServerUiPlugin.getDefault().getLog().log(e.getStatus());
        }
        return true;
    }
}

