/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.ICloudFoundryServiceWizardIconProvider;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

class CFServiceWizardDynamicIconLoader
extends Thread {
    private final Object lock = new Object();
    private final List<ServiceWizardMapEntry> iconsToRetrieve = new ArrayList<ServiceWizardMapEntry>();
    private final CloudFoundryServer server;
    private final ICloudFoundryServiceWizardIconProvider iconProvider;
    private boolean isRunning = true;
    private Map<String, Image> imageMap = new HashMap<String, Image>();

    public CFServiceWizardDynamicIconLoader(ICloudFoundryServiceWizardIconProvider iconProvider, CloudFoundryServer server) {
        super(CFServiceWizardDynamicIconLoader.class.getName());
        this.setDaemon(true);
        this.iconProvider = iconProvider;
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIconToFrontOfRetrieveList(CloudServiceOffering offering, Label imageLabel) {
        Object object = this.lock;
        synchronized (object) {
            ServiceWizardMapEntry me = new ServiceWizardMapEntry(offering, imageLabel);
            this.iconsToRetrieve.add(0, me);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIconToRetrieveList(CloudServiceOffering offering, Label imageLabel) {
        ServiceWizardMapEntry me = new ServiceWizardMapEntry(offering, imageLabel);
        Object object = this.lock;
        synchronized (object) {
            this.iconsToRetrieve.add(me);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExecutorService es = Executors.newFixedThreadPool(10);
        while (this.isRunning) {
            try {
                ArrayList<ServiceWizardMapEntry> localIconsToRetrieve = null;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(1000L);
                    if (this.isRunning && this.iconsToRetrieve.size() > 0) {
                        localIconsToRetrieve = new ArrayList<ServiceWizardMapEntry>();
                        localIconsToRetrieve.addAll(this.iconsToRetrieve);
                        this.iconsToRetrieve.clear();
                    }
                }
                if (!this.isRunning || localIconsToRetrieve == null) continue;
                for (ServiceWizardMapEntry e : localIconsToRetrieve) {
                    IconRetrieveRunnable r = new IconRetrieveRunnable(e);
                    es.execute(r);
                }
                localIconsToRetrieve.clear();
            }
            catch (InterruptedException interruptedException) {
                this.isRunning = false;
            }
        }
        es.shutdownNow();
        try {
            es.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
        Map<String, Image> map = this.imageMap;
        synchronized (map) {
            Set<Map.Entry<String, Image>> s = this.imageMap.entrySet();
            for (Map.Entry<String, Image> e : s) {
                if (!e.getValue().isDisposed()) continue;
                e.getValue().dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = false;
        }
    }

    private class IconRetrieveRunnable
    implements Runnable {
        private final ServiceWizardMapEntry entry;

        public IconRetrieveRunnable(ServiceWizardMapEntry entry) {
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Image labelImage;
            CloudServiceOffering cso = this.entry.getOffering();
            String mapId = cso.getName() + "-" + cso.getProvider();
            Image result = null;
            Map map = CFServiceWizardDynamicIconLoader.this.imageMap;
            synchronized (map) {
                Image i = (Image)CFServiceWizardDynamicIconLoader.this.imageMap.get(mapId);
                if (i != null) {
                    result = i;
                }
            }
            if (result == null) {
                ImageDescriptor imageDesc;
                Image img;
                block14: {
                    img = null;
                    imageDesc = CFServiceWizardDynamicIconLoader.this.iconProvider.getServiceIcon(this.entry.getOffering(), CFServiceWizardDynamicIconLoader.this.server);
                    if (imageDesc != null) {
                        try {
                            img = imageDesc.createImage(false);
                        }
                        catch (Exception ex) {
                            if (!Logger.INFO) break block14;
                            Logger.println("/debug/info", this, "run", "Error creating image: " + imageDesc.toString(), (Throwable)ex);
                        }
                    }
                }
                if (img == null && (imageDesc = CFServiceWizardDynamicIconLoader.this.iconProvider.getDefaultServiceIcon(this.entry.getOffering(), CFServiceWizardDynamicIconLoader.this.server)) != null) {
                    img = imageDesc.createImage();
                }
                if (img != null) {
                    Image resizeImg;
                    result = resizeImg = this.resizeImage(img, 32, 32);
                    Map map2 = CFServiceWizardDynamicIconLoader.this.imageMap;
                    synchronized (map2) {
                        CFServiceWizardDynamicIconLoader.this.imageMap.put(mapId, resizeImg);
                    }
                }
            }
            if ((labelImage = result) == null) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Label l = IconRetrieveRunnable.this.entry.getImageLabel();
                    if (!l.isDisposed()) {
                        l.setImage(labelImage);
                    }
                }
            });
        }

        private Image resizeImage(Image oldImage, int newWidth, int newHeight) {
            double scaleRatio;
            Rectangle oldImageBounds = oldImage.getBounds();
            if (oldImage.getBounds().width > oldImage.getBounds().height) {
                scaleRatio = (double)newWidth / (double)oldImageBounds.width;
                newHeight = (int)(scaleRatio * (double)oldImageBounds.height);
            } else {
                scaleRatio = (double)newHeight / (double)oldImageBounds.height;
                newWidth = (int)(scaleRatio * (double)oldImageBounds.width);
            }
            Image newImage = new Image((Device)Display.getDefault(), newWidth, newHeight);
            GC gc = new GC((Drawable)newImage);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(oldImage, 0, 0, oldImageBounds.width, oldImageBounds.height, 0, 0, newWidth, newHeight);
            gc.dispose();
            oldImage.dispose();
            return newImage;
        }
    }

    private static class ServiceWizardMapEntry {
        private CloudServiceOffering offering;
        private Label imageLabel;

        public ServiceWizardMapEntry(CloudServiceOffering offering, Label imageLabel) {
            this.offering = offering;
            this.imageLabel = imageLabel;
        }

        public CloudServiceOffering getOffering() {
            return this.offering;
        }

        public Label getImageLabel() {
            return this.imageLabel;
        }
    }
}

