/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudServicePlan;
import org.eclipse.cft.server.core.internal.client.LocalCloudService;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;

class ServiceInstance {
    private String name;
    private String userDefinedName;
    private int selectedPlan = 0;
    private Rectangle appxLocation = null;
    private final String[] planNames;
    private final String[] planDisplayNames;
    private final List<CloudServicePlan> sortedPlans;
    private final CloudServiceOffering offering;

    public ServiceInstance(String name, List<CloudServicePlan> plans, CloudServiceOffering offering) {
        this.name = name;
        this.sortedPlans = new ArrayList<CloudServicePlan>(plans);
        Collections.sort(this.sortedPlans, new Comparator<CloudServicePlan>(){

            @Override
            public int compare(CloudServicePlan p1, CloudServicePlan p2) {
                if (p1.isFree()) {
                    return -1;
                }
                if (p2.isFree()) {
                    return 1;
                }
                return 0;
            }
        });
        this.offering = offering;
        this.planNames = new String[this.sortedPlans.size()];
        this.planDisplayNames = new String[this.sortedPlans.size()];
        int x = 0;
        while (x < this.sortedPlans.size()) {
            CloudServicePlan plan = this.sortedPlans.get(x);
            this.planNames[x] = plan.getName();
            this.planDisplayNames[x] = plan.isFree() ? NLS.bind((String)Messages.CloudFoundryServiceWizardPageRightPanel_FREE_PLAN, (Object)plan.getName()) : plan.getName();
            ++x;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSelectedPlan() {
        return this.selectedPlan;
    }

    public void setSelectedPlan(int selectedPlan) {
        this.selectedPlan = selectedPlan;
    }

    public void setUserDefinedName(String userDefinedName) {
        this.userDefinedName = userDefinedName;
    }

    public String getUserDefinedName() {
        return this.userDefinedName;
    }

    public String[] getPlanNames() {
        return this.planNames;
    }

    public String[] getPlanDisplayNames() {
        return this.planDisplayNames;
    }

    public List<CloudServicePlan> getPlans() {
        return this.sortedPlans;
    }

    public void setAppxLocation(Rectangle appxLocation) {
        this.appxLocation = appxLocation;
    }

    public Rectangle getAppxLocation() {
        return this.appxLocation;
    }

    public LocalCloudService convertToLocalService() {
        LocalCloudService localService = new LocalCloudService("");
        localService.setName(this.getUserDefinedName());
        localService.setVersion(this.offering.getVersion());
        localService.setLabel(this.offering.getLabel());
        localService.setProvider(this.offering.getProvider());
        localService.setPlan(this.planNames[this.getSelectedPlan()]);
        return localService;
    }
}

