/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.AbstractModuleResourceArchive;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class ModuleResourceApplicationArchive
extends AbstractModuleResourceArchive {
    public ModuleResourceApplicationArchive(IModule module, List<IModuleResource> resources) throws CoreException {
        super(module, resources);
        if (resources == null || resources.isEmpty()) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.ModuleResourceApplicationArchive_ERROR_NO_DEPLOYABLE_RES_FOUND, (Object)module.getName(), (Object)module.getId())));
        }
    }

    @Override
    protected AbstractModuleResourceArchive.ModuleFolderEntryAdapter getModuleFolderAdapter(IModuleFolder folder) {
        return new ModuleResourceFolderEntryAdapter(folder);
    }

    @Override
    protected AbstractModuleResourceArchive.ModuleFileEntryAdapter getFileResourceEntryAdapter(IModuleFile moduleFile) {
        return new ModuleResourceFileEntryAdapter(moduleFile);
    }

    public String getFilename() {
        return this.getModule().getName();
    }

    public class ModuleResourceFileEntryAdapter
    extends AbstractModuleResourceArchive.ModuleFileEntryAdapter {
        public ModuleResourceFileEntryAdapter(IModuleFile moduleFile) {
            super(moduleFile);
        }

        @Override
        protected String computeName(IModuleResource resource) {
            String name = resource.getModuleRelativePath().append(resource.getName()).toString();
            return name;
        }
    }

    public class ModuleResourceFolderEntryAdapter
    extends AbstractModuleResourceArchive.ModuleFolderEntryAdapter {
        public ModuleResourceFolderEntryAdapter(IModuleFolder folder) {
            super(folder);
        }

        @Override
        protected String computeName(IModuleResource resource) {
            String name = String.valueOf(resource.getModuleRelativePath().append(resource.getName()).toString()) + "/";
            return name;
        }
    }
}

