/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.adapters;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.operations.UpdateTraceOperation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConnectionAdapter
implements IPropertySource {
    private static final String CATEGORY_NAME = "General";
    private final Connection connection;
    private final ArtifactHelper artifactHelper;

    public ConnectionAdapter(Connection theItem) {
        this.connection = theItem;
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        this.artifactHelper = new ArtifactHelper(artifactModel);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor originDescriptor = new PropertyDescriptor((Object)DescriptorIDs.ORIGIN, "Origin");
        originDescriptor.setCategory(CATEGORY_NAME);
        propertyDescriptors.add(originDescriptor);
        PropertyDescriptor targetDescriptor = new PropertyDescriptor((Object)DescriptorIDs.TARGETS, "Targets");
        targetDescriptor.setCategory(CATEGORY_NAME);
        propertyDescriptors.add(targetDescriptor);
        PropertyDescriptor typeDescriptor = new PropertyDescriptor((Object)DescriptorIDs.TYPE, "Type");
        typeDescriptor.setCategory(CATEGORY_NAME);
        propertyDescriptors.add(typeDescriptor);
        propertyDescriptors.addAll(this.connection.getTlink().eClass().getEAllAttributes().stream().map(attribute -> new TextPropertyDescriptor((Object)attribute.getName(), attribute.getName())).collect(Collectors.toList()));
        IPropertyDescriptor[] dummyList = new IPropertyDescriptor[propertyDescriptors.size()];
        return propertyDescriptors.toArray(dummyList);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals((Object)DescriptorIDs.ORIGIN)) {
            return this.connection.getOrigins().stream().map(o -> this.artifactHelper.getArtifactLabel(o)).collect(Collectors.toList());
        }
        if (id.equals((Object)DescriptorIDs.TARGETS)) {
            return this.connection.getTargets().stream().map(arg_0 -> ((ArtifactHelper)this.artifactHelper).getArtifactLabel(arg_0)).collect(Collectors.toList());
        }
        if (id.equals((Object)DescriptorIDs.TYPE)) {
            return this.connection.getTlink().eClass().getName();
        }
        EStructuralFeature a = this.connection.getTlink().eClass().getEStructuralFeature((String)id);
        return this.connection.getTlink().eGet(a);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        IWorkbenchPartSite adapter = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
        UpdateTraceOperation updateTraceOperation = new UpdateTraceOperation("Update trace link", this.connection, id, value);
        updateTraceOperation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
        try {
            operationHistory.execute((IUndoableOperation)updateTraceOperation, null, (IAdaptable)adapter);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    private static enum DescriptorIDs {
        ORIGIN,
        TARGETS,
        TYPE;

    }
}

